/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.query;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLCharacterSet;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLConstants;
import org.apache.shardingsphere.db.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.MySQLTextResultSetRowPacket;
import org.apache.shardingsphere.db.protocol.mysql.packet.command.query.text.query.MySQLComQueryPacket;
import org.apache.shardingsphere.db.protocol.packet.DatabasePacket;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.ProxySQLComQueryParser;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.MultiStatementsUpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.command.executor.QueryCommandExecutor;
import org.apache.shardingsphere.proxy.frontend.command.executor.ResponseType;
import org.apache.shardingsphere.proxy.frontend.mysql.command.ServerStatusFlagCalculator;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.builder.ResponsePacketBuilder;
import org.apache.shardingsphere.proxy.frontend.mysql.command.query.text.query.MySQLMultiStatementsHandler;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.UpdateStatement;

public final class MySQLComQueryPacketExecutor
implements QueryCommandExecutor {
    private final ConnectionSession connectionSession;
    private final ProxyBackendHandler proxyBackendHandler;
    private final int characterSet;
    private volatile ResponseType responseType;

    public MySQLComQueryPacketExecutor(MySQLComQueryPacket packet, ConnectionSession connectionSession) throws SQLException {
        this.connectionSession = connectionSession;
        DatabaseType databaseType = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL");
        SQLStatement sqlStatement = ProxySQLComQueryParser.parse((String)packet.getSQL(), (DatabaseType)databaseType, (ConnectionSession)connectionSession);
        this.proxyBackendHandler = this.areMultiStatements(connectionSession, sqlStatement, packet.getSQL()) ? new MySQLMultiStatementsHandler(connectionSession, sqlStatement, packet.getSQL()) : ProxyBackendHandlerFactory.newInstance((DatabaseType)databaseType, (String)packet.getSQL(), (SQLStatement)sqlStatement, (ConnectionSession)connectionSession, (HintValueContext)packet.getHintValueContext());
        this.characterSet = ((MySQLCharacterSet)connectionSession.getAttributeMap().attr(MySQLConstants.CHARACTER_SET_ATTRIBUTE_KEY).get()).getId();
    }

    private boolean areMultiStatements(ConnectionSession connectionSession, SQLStatement sqlStatement, String sql) {
        return this.isMultiStatementsEnabled(connectionSession) && this.isSuitableMultiStatementsSQLStatement(sqlStatement) && sql.contains(";");
    }

    private boolean isMultiStatementsEnabled(ConnectionSession connectionSession) {
        return connectionSession.getAttributeMap().hasAttr(MySQLConstants.OPTION_MULTI_STATEMENTS_ATTRIBUTE_KEY) && 0 == (Integer)connectionSession.getAttributeMap().attr(MySQLConstants.OPTION_MULTI_STATEMENTS_ATTRIBUTE_KEY).get();
    }

    private boolean isSuitableMultiStatementsSQLStatement(SQLStatement sqlStatement) {
        return this.containsInsertOnDuplicateKey(sqlStatement) || sqlStatement instanceof UpdateStatement || sqlStatement instanceof DeleteStatement;
    }

    private boolean containsInsertOnDuplicateKey(SQLStatement sqlStatement) {
        return sqlStatement instanceof InsertStatement && ((InsertStatement)sqlStatement).getOnDuplicateKeyColumns().isPresent();
    }

    public Collection<DatabasePacket> execute() throws SQLException {
        ResponseHeader responseHeader = this.proxyBackendHandler.execute();
        if (responseHeader instanceof QueryResponseHeader) {
            return this.processQuery((QueryResponseHeader)responseHeader);
        }
        this.responseType = ResponseType.UPDATE;
        if (responseHeader instanceof MultiStatementsUpdateResponseHeader) {
            return this.processMultiStatementsUpdate((MultiStatementsUpdateResponseHeader)responseHeader);
        }
        return this.processUpdate((UpdateResponseHeader)responseHeader);
    }

    private Collection<DatabasePacket> processQuery(QueryResponseHeader queryResponseHeader) {
        this.responseType = ResponseType.QUERY;
        return ResponsePacketBuilder.buildQueryResponsePackets(queryResponseHeader, this.characterSet, ServerStatusFlagCalculator.calculateFor(this.connectionSession, true));
    }

    private Collection<DatabasePacket> processUpdate(UpdateResponseHeader updateResponseHeader) {
        return ResponsePacketBuilder.buildUpdateResponsePackets(updateResponseHeader, ServerStatusFlagCalculator.calculateFor(this.connectionSession, true));
    }

    private Collection<DatabasePacket> processMultiStatementsUpdate(MultiStatementsUpdateResponseHeader responseHeader) {
        LinkedList<DatabasePacket> result = new LinkedList<DatabasePacket>();
        int index = 0;
        for (UpdateResponseHeader each : responseHeader.getUpdateResponseHeaders()) {
            boolean lastPacket = ++index == responseHeader.getUpdateResponseHeaders().size();
            result.addAll(ResponsePacketBuilder.buildUpdateResponsePackets(each, ServerStatusFlagCalculator.calculateFor(this.connectionSession, lastPacket)));
        }
        return result;
    }

    public boolean next() throws SQLException {
        return this.proxyBackendHandler.next();
    }

    public MySQLPacket getQueryRowPacket() throws SQLException {
        return new MySQLTextResultSetRowPacket((Collection)this.proxyBackendHandler.getRowData().getData());
    }

    public void close() throws SQLException {
        this.proxyBackendHandler.close();
    }

    @Generated
    public ResponseType getResponseType() {
        return this.responseType;
    }
}

