/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.arguments;

import com.google.common.net.InetAddresses;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class BootstrapArguments {
    private static final String DEFAULT_CONFIG_PATH = System.getenv().getOrDefault("PROXY_DEFAULT_CONFIG_PATH", "/conf/");
    private static final String DEFAULT_BIND_ADDRESS = "0.0.0.0";
    private final String[] args;

    public Optional<Integer> getPort() {
        if (0 == this.args.length) {
            return Optional.empty();
        }
        try {
            int port = Integer.parseInt(this.args[0]);
            if (port < 0) {
                return Optional.empty();
            }
            return Optional.of(port);
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException(String.format("Invalid port `%s`.", this.args[0]));
        }
    }

    public String getConfigurationPath() {
        return this.args.length < 2 ? DEFAULT_CONFIG_PATH : this.paddingWithSlash(this.args[1]);
    }

    private String paddingWithSlash(String pathArg) {
        StringBuilder result = new StringBuilder(pathArg);
        if (!pathArg.startsWith("/")) {
            result.insert(0, '/');
        }
        if (!pathArg.endsWith("/")) {
            result.append('/');
        }
        return result.toString();
    }

    public List<String> getAddresses() {
        if (this.args.length < 3) {
            return Collections.singletonList(DEFAULT_BIND_ADDRESS);
        }
        return Arrays.stream(this.args[2].split(",")).filter(InetAddresses::isInetAddress).collect(Collectors.toList());
    }

    public Optional<String> getSocketPath() {
        if (this.args.length < 3) {
            return Optional.empty();
        }
        List<String> addresses = Arrays.asList(this.args[2].split(","));
        return addresses.stream().filter(address -> !InetAddresses.isInetAddress((String)address)).filter(this::isValidPath).findFirst();
    }

    private boolean isValidPath(String path) {
        try {
            Paths.get(path, new String[0]);
        }
        catch (InvalidPathException ignored) {
            throw new IllegalArgumentException(String.format("Invalid path `%s`.", path));
        }
        return true;
    }

    @Generated
    public BootstrapArguments(String[] args) {
        this.args = args;
    }
}

