/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.state.impl;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ExecutorService;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtils;
import org.apache.shardingsphere.proxy.frontend.command.CommandExecutorTask;
import org.apache.shardingsphere.proxy.frontend.executor.ConnectionThreadExecutorGroup;
import org.apache.shardingsphere.proxy.frontend.executor.UserExecutorGroup;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;
import org.apache.shardingsphere.proxy.frontend.state.ProxyState;
import org.apache.shardingsphere.transaction.api.TransactionType;

public final class OKProxyState
implements ProxyState {
    @Override
    public void execute(ChannelHandlerContext context, Object message, DatabaseProtocolFrontendEngine databaseProtocolFrontendEngine, ConnectionSession connectionSession) {
        ExecutorService executorService = this.determineSuitableExecutorService(connectionSession);
        context.channel().config().setAutoRead(false);
        executorService.execute(new CommandExecutorTask(databaseProtocolFrontendEngine, connectionSession, context, message));
    }

    private ExecutorService determineSuitableExecutorService(ConnectionSession connectionSession) {
        return this.requireOccupyThreadForConnection(connectionSession) ? ConnectionThreadExecutorGroup.getInstance().get(connectionSession.getConnectionId()) : UserExecutorGroup.getInstance().getExecutorService();
    }

    private boolean requireOccupyThreadForConnection(ConnectionSession connectionSession) {
        return TransactionType.isDistributedTransaction((TransactionType)TransactionUtils.getTransactionType((TransactionConnectionContext)connectionSession.getConnectionContext().getTransactionContext()));
    }
}

