/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.consistencycheck.util;

import java.util.List;
import java.util.Optional;
import lombok.Generated;

public final class ConsistencyCheckSequence {
    public static final int MIN_SEQUENCE = 1;
    public static final int MAX_SEQUENCE = 3;

    public static int getNextSequence(int currentSequence) {
        int nextSequence = currentSequence + 1;
        return nextSequence > 3 ? 1 : nextSequence;
    }

    public static Optional<Integer> getPreviousSequence(List<Integer> sequences, int currentSequence) {
        if (sequences.size() <= 1) {
            return Optional.empty();
        }
        sequences.sort(Integer::compareTo);
        Integer index = null;
        for (int i = 0; i < sequences.size(); ++i) {
            if (sequences.get(i) != currentSequence) continue;
            index = i;
            break;
        }
        if (null == index) {
            return Optional.empty();
        }
        return Optional.of(index >= 1 ? sequences.get(index - 1) : 3);
    }

    @Generated
    private ConsistencyCheckSequence() {
    }

    @Generated
    public String toString() {
        return "ConsistencyCheckSequence(super=" + super.toString() + ")";
    }
}

