/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.connection;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.adapter.executor.ForceExecuteTemplate;
import org.apache.shardingsphere.driver.jdbc.adapter.invocation.MethodInvocationRecorder;
import org.apache.shardingsphere.driver.jdbc.core.savepoint.ShardingSphereSavepoint;
import org.apache.shardingsphere.infra.exception.kernel.connection.OverallConnectionNotEnoughException;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionManager;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.transaction.ConnectionTransaction;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.savepoint.ConnectionSavepointManager;

public final class DriverDatabaseConnectionManager
implements DatabaseConnectionManager<Connection>,
AutoCloseable {
    private final String currentDatabaseName;
    private final ContextManager contextManager;
    private final Map<String, DataSource> dataSourceMap;
    private final ConnectionContext connectionContext;
    private final Multimap<String, Connection> cachedConnections = LinkedHashMultimap.create();
    private final MethodInvocationRecorder<Connection> methodInvocationRecorder = new MethodInvocationRecorder();
    private final ForceExecuteTemplate<Connection> forceExecuteTemplate = new ForceExecuteTemplate();

    public DriverDatabaseConnectionManager(String currentDatabaseName, ContextManager contextManager) {
        this.currentDatabaseName = currentDatabaseName;
        this.contextManager = contextManager;
        this.dataSourceMap = contextManager.getStorageUnits(currentDatabaseName).entrySet().stream().collect(Collectors.toMap(entry -> this.getKey(currentDatabaseName, (String)entry.getKey()), entry -> ((StorageUnit)entry.getValue()).getDataSource()));
        this.connectionContext = new ConnectionContext(() -> this.cachedConnections.keySet());
        this.connectionContext.setCurrentDatabaseName(currentDatabaseName);
    }

    private String getKey(String databaseName, String dataSourceName) {
        return databaseName.toLowerCase() + "." + dataSourceName;
    }

    public ConnectionTransaction getConnectionTransaction() {
        TransactionRule rule = (TransactionRule)this.contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(TransactionRule.class);
        return new ConnectionTransaction(rule, this.connectionContext.getTransactionContext());
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.methodInvocationRecorder.record("setAutoCommit", connection -> connection.setAutoCommit(autoCommit));
        this.forceExecuteTemplate.execute(this.getCachedConnections(), connection -> connection.setAutoCommit(autoCommit));
    }

    private Collection<Connection> getCachedConnections() {
        return this.cachedConnections.values();
    }

    public void begin() throws SQLException {
        ConnectionTransaction connectionTransaction = this.getConnectionTransaction();
        if (TransactionType.isDistributedTransaction((TransactionType)connectionTransaction.getTransactionType())) {
            this.close();
            connectionTransaction.begin();
        }
        this.connectionContext.getTransactionContext().beginTransaction(String.valueOf(connectionTransaction.getTransactionType()), (TransactionManager)connectionTransaction.getDistributedTransactionManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        ConnectionTransaction connectionTransaction = this.getConnectionTransaction();
        try {
            if (connectionTransaction.isLocalTransaction() && this.connectionContext.getTransactionContext().isExceptionOccur()) {
                this.forceExecuteTemplate.execute(this.getCachedConnections(), Connection::rollback);
            } else if (connectionTransaction.isLocalTransaction()) {
                this.forceExecuteTemplate.execute(this.getCachedConnections(), Connection::commit);
            } else {
                connectionTransaction.commit();
            }
        }
        finally {
            this.methodInvocationRecorder.remove("setSavepoint");
            for (Connection each : this.getCachedConnections()) {
                ConnectionSavepointManager.getInstance().transactionFinished(each);
            }
            this.connectionContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        ConnectionTransaction connectionTransaction = this.getConnectionTransaction();
        try {
            if (connectionTransaction.isLocalTransaction()) {
                this.forceExecuteTemplate.execute(this.getCachedConnections(), Connection::rollback);
            } else {
                connectionTransaction.rollback();
            }
        }
        finally {
            this.methodInvocationRecorder.remove("setSavepoint");
            for (Connection each : this.getCachedConnections()) {
                ConnectionSavepointManager.getInstance().transactionFinished(each);
            }
            this.connectionContext.close();
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        for (Connection each : this.getCachedConnections()) {
            ConnectionSavepointManager.getInstance().rollbackToSavepoint(each, savepoint.getSavepointName());
        }
    }

    public Savepoint setSavepoint(String savepointName) throws SQLException {
        ShardingSphereSavepoint result = new ShardingSphereSavepoint(savepointName);
        for (Connection each : this.getCachedConnections()) {
            ConnectionSavepointManager.getInstance().setSavepoint(each, savepointName);
        }
        this.methodInvocationRecorder.record("setSavepoint", target -> ConnectionSavepointManager.getInstance().setSavepoint(target, savepointName));
        return result;
    }

    public Savepoint setSavepoint() throws SQLException {
        ShardingSphereSavepoint result = new ShardingSphereSavepoint();
        for (Connection each : this.getCachedConnections()) {
            ConnectionSavepointManager.getInstance().setSavepoint(each, result.getSavepointName());
        }
        this.methodInvocationRecorder.record("setSavepoint", target -> ConnectionSavepointManager.getInstance().setSavepoint(target, result.getSavepointName()));
        return result;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.methodInvocationRecorder.remove("setSavepoint");
        for (Connection each : this.getCachedConnections()) {
            ConnectionSavepointManager.getInstance().releaseSavepoint(each, savepoint.getSavepointName());
        }
    }

    public Optional<Integer> getTransactionIsolation() throws SQLException {
        return this.cachedConnections.values().isEmpty() ? Optional.empty() : Optional.of(((Connection)this.cachedConnections.values().iterator().next()).getTransactionIsolation());
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.methodInvocationRecorder.record("setTransactionIsolation", connection -> connection.setTransactionIsolation(level));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setTransactionIsolation(level));
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.methodInvocationRecorder.record("setReadOnly", connection -> connection.setReadOnly(readOnly));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setReadOnly(readOnly));
    }

    public boolean isValid(int timeout) throws SQLException {
        for (Connection each : this.cachedConnections.values()) {
            if (each.isValid(timeout)) continue;
            return false;
        }
        return true;
    }

    public String getRandomPhysicalDataSourceName() {
        return this.getRandomPhysicalDatabaseAndDataSourceName()[1];
    }

    private String[] getRandomPhysicalDatabaseAndDataSourceName() {
        Sets.SetView cachedPhysicalDataSourceNames = Sets.intersection(this.dataSourceMap.keySet(), (Set)this.cachedConnections.keySet());
        Sets.SetView databaseAndDatasourceNames = cachedPhysicalDataSourceNames.isEmpty() ? this.dataSourceMap.keySet() : cachedPhysicalDataSourceNames;
        return ((String)new ArrayList(databaseAndDatasourceNames).get(ThreadLocalRandom.current().nextInt(databaseAndDatasourceNames.size()))).split("\\.");
    }

    public Connection getRandomConnection() throws SQLException {
        String[] databaseAndDataSourceName = this.getRandomPhysicalDatabaseAndDataSourceName();
        return this.getConnections0(databaseAndDataSourceName[0], databaseAndDataSourceName[1], 0, 1, ConnectionMode.MEMORY_STRICTLY).get(0);
    }

    public List<Connection> getConnections(String databaseName, String dataSourceName, int connectionOffset, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        return this.getConnections0(databaseName, dataSourceName, connectionOffset, connectionSize, connectionMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> getConnections0(String databaseName, String dataSourceName, int connectionOffset, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        List<Connection> result;
        Collection connections;
        String cacheKey = this.getKey(databaseName, dataSourceName);
        DataSource dataSource = this.currentDatabaseName.equals(databaseName) ? this.dataSourceMap.get(cacheKey) : ((StorageUnit)this.contextManager.getStorageUnits(databaseName).get(dataSourceName)).getDataSource();
        Preconditions.checkNotNull((Object)dataSource, (String)"Missing the data source name: '%s'", (Object)dataSourceName);
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)cacheKey);
        }
        int maxConnectionSize = connectionOffset + connectionSize;
        if (connections.size() >= maxConnectionSize) {
            result = new ArrayList(connections).subList(connectionOffset, maxConnectionSize);
        } else {
            if (connections.isEmpty()) {
                List<Connection> newConnections = this.createConnections(databaseName, dataSourceName, dataSource, maxConnectionSize, connectionMode);
                result = new ArrayList<Connection>(newConnections).subList(connectionOffset, maxConnectionSize);
                Multimap<String, Connection> multimap2 = this.cachedConnections;
                synchronized (multimap2) {
                    this.cachedConnections.putAll((Object)cacheKey, newConnections);
                }
            }
            ArrayList<Connection> allConnections = new ArrayList<Connection>(maxConnectionSize);
            allConnections.addAll(connections);
            List<Connection> newConnections = this.createConnections(databaseName, dataSourceName, dataSource, maxConnectionSize - connections.size(), connectionMode);
            allConnections.addAll(newConnections);
            result = allConnections.subList(connectionOffset, maxConnectionSize);
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)cacheKey, newConnections);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> createConnections(String databaseName, String dataSourceName, DataSource dataSource, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        if (1 == connectionSize) {
            Connection connection = this.createConnection(databaseName, dataSourceName, dataSource, this.connectionContext.getTransactionContext());
            this.methodInvocationRecorder.replay(connection);
            return Collections.singletonList(connection);
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(databaseName, dataSourceName, dataSource, connectionSize, this.connectionContext.getTransactionContext());
        }
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            return this.createConnections(databaseName, dataSourceName, dataSource, connectionSize, this.connectionContext.getTransactionContext());
        }
    }

    private List<Connection> createConnections(String databaseName, String dataSourceName, DataSource dataSource, int connectionSize, TransactionConnectionContext transactionConnectionContext) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            try {
                Connection connection = this.createConnection(databaseName, dataSourceName, dataSource, transactionConnectionContext);
                this.methodInvocationRecorder.replay(connection);
                result.add(connection);
                continue;
            }
            catch (SQLException ex) {
                for (Connection each : result) {
                    each.close();
                }
                throw new OverallConnectionNotEnoughException(connectionSize, result.size(), (Exception)ex).toSQLException();
            }
        }
        return result;
    }

    private Connection createConnection(String databaseName, String dataSourceName, DataSource dataSource, TransactionConnectionContext transactionConnectionContext) throws SQLException {
        Optional connectionInTransaction = this.getConnectionTransaction().getConnection(databaseName, dataSourceName, transactionConnectionContext);
        return connectionInTransaction.isPresent() ? (Connection)connectionInTransaction.get() : dataSource.getConnection();
    }

    @Override
    public void close() throws SQLException {
        try {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::close);
        }
        finally {
            this.cachedConnections.clear();
        }
    }

    @Generated
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

