/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.resultset;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.core.resultset.GeneratedKeysResultSetMetaData;
import org.apache.shardingsphere.driver.jdbc.unsupported.AbstractUnsupportedGeneratedKeysResultSet;

public final class GeneratedKeysResultSet
extends AbstractUnsupportedGeneratedKeysResultSet {
    private final String column;
    private final Iterator<Comparable<?>> values;
    private final Statement statement;
    private Comparable<?> currentValue;
    private boolean closed;

    public GeneratedKeysResultSet() {
        this.column = null;
        this.values = Collections.emptyIterator();
        this.statement = null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean next() {
        if (this.closed || !this.values.hasNext()) {
            this.currentValue = null;
            return false;
        }
        this.currentValue = this.values.next();
        return true;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        this.checkState();
        return new GeneratedKeysResultSetMetaData(this.column);
    }

    @Override
    public boolean wasNull() {
        this.checkState();
        return false;
    }

    @Override
    public String getString(int columnIndex) {
        this.checkStateForGetData();
        return this.currentValue.toString();
    }

    @Override
    public String getString(String columnLabel) {
        return this.getString(1);
    }

    @Override
    public String getNString(int columnIndex) {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) {
        return this.getString(columnLabel);
    }

    @Override
    public byte getByte(int columnIndex) {
        this.checkStateForGetData();
        return Byte.parseByte(this.getString(columnIndex));
    }

    @Override
    public byte getByte(String columnLabel) {
        return this.getByte(1);
    }

    @Override
    public short getShort(int columnIndex) {
        this.checkStateForGetData();
        return Short.parseShort(this.getString(columnIndex));
    }

    @Override
    public short getShort(String columnLabel) {
        return this.getShort(1);
    }

    @Override
    public int getInt(int columnIndex) {
        this.checkStateForGetData();
        return Integer.parseInt(this.getString(columnIndex));
    }

    @Override
    public int getInt(String columnLabel) {
        return this.getInt(1);
    }

    @Override
    public long getLong(int columnIndex) {
        this.checkStateForGetData();
        return Long.parseLong(this.getString(columnIndex));
    }

    @Override
    public long getLong(String columnLabel) {
        return this.getLong(1);
    }

    @Override
    public float getFloat(int columnIndex) {
        this.checkStateForGetData();
        return Float.parseFloat(this.getString(columnIndex));
    }

    @Override
    public float getFloat(String columnLabel) {
        return this.getFloat(1);
    }

    @Override
    public double getDouble(int columnIndex) {
        this.checkStateForGetData();
        return Double.parseDouble(this.getString(columnIndex));
    }

    @Override
    public double getDouble(String columnLabel) {
        return this.getDouble(1);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) {
        this.checkStateForGetData();
        return new BigDecimal(this.getString(columnIndex)).setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) {
        return this.getBigDecimal(1, scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        this.checkStateForGetData();
        return new BigDecimal(this.getString(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) {
        return this.getBigDecimal(1);
    }

    @Override
    public byte[] getBytes(int columnIndex) {
        this.checkStateForGetData();
        return this.getString(columnIndex).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getBytes(String columnLabel) {
        return this.getBytes(1);
    }

    @Override
    public Object getObject(int columnIndex) {
        this.checkStateForGetData();
        return this.currentValue;
    }

    @Override
    public Object getObject(String columnLabel) {
        return this.getObject(1);
    }

    @Override
    public int findColumn(String columnLabel) {
        this.checkState();
        return 1;
    }

    @Override
    public int getType() {
        this.checkState();
        return 1003;
    }

    @Override
    public int getConcurrency() {
        this.checkState();
        return 1007;
    }

    @Override
    public Statement getStatement() {
        this.checkState();
        return this.statement;
    }

    private void checkStateForGetData() {
        this.checkState();
        Preconditions.checkNotNull(this.currentValue, (Object)"ResultSet should call next or has no more data.");
    }

    private void checkState() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"ResultSet has closed.");
    }

    @Generated
    public GeneratedKeysResultSet(String column, Iterator<Comparable<?>> values, Statement statement) {
        this.column = column;
        this.values = values;
        this.statement = statement;
    }
}

