/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceGeneratedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.jdbc.JDBCInstanceMetaData;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.ShardingSphereStatisticsFactory;
import org.apache.shardingsphere.mode.metadata.factory.ExternalMetaDataFactory;
import org.apache.shardingsphere.mode.metadata.factory.InternalMetaDataFactory;
import org.apache.shardingsphere.mode.metadata.manager.SwitchingResource;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;

public final class MetaDataContextsFactory {
    public static MetaDataContexts create(MetaDataPersistService persistService, ContextManagerBuilderParameter param, ComputeNodeInstanceContext instanceContext) throws SQLException {
        return MetaDataContextsFactory.isCreateByLocal(persistService) ? MetaDataContextsFactory.createByLocal(persistService, param, instanceContext) : MetaDataContextsFactory.createByRepository(persistService, param, instanceContext);
    }

    private static boolean isCreateByLocal(MetaDataPersistService persistService) {
        return persistService.getDatabaseMetaDataFacade().getDatabase().loadAllDatabaseNames().isEmpty();
    }

    private static MetaDataContexts createByLocal(MetaDataPersistService persistService, ContextManagerBuilderParameter param, ComputeNodeInstanceContext instanceContext) throws SQLException {
        Collection<RuleConfiguration> globalRuleConfigs = param.getGlobalRuleConfigs();
        ConfigurationProperties props = new ConfigurationProperties(param.getProps());
        Map<String, ShardingSphereDatabase> databases = ExternalMetaDataFactory.create(param.getDatabaseConfigs(), props, instanceContext);
        MetaDataContexts result = MetaDataContextsFactory.newMetaDataContexts(persistService, param, globalRuleConfigs, databases, props);
        MetaDataContextsFactory.persistDatabaseConfigurations(result, param, persistService);
        MetaDataContextsFactory.persistMetaData(result, persistService);
        return result;
    }

    private static MetaDataContexts createByRepository(MetaDataPersistService persistService, ContextManagerBuilderParameter param, ComputeNodeInstanceContext instanceContext) {
        Map<String, DatabaseConfiguration> effectiveDatabaseConfigs = MetaDataContextsFactory.createEffectiveDatabaseConfigurations(MetaDataContextsFactory.getDatabaseNames(instanceContext, param.getDatabaseConfigs(), persistService), param.getDatabaseConfigs(), persistService);
        Collection<RuleConfiguration> globalRuleConfigs = persistService.getGlobalRuleService().load();
        ConfigurationProperties props = new ConfigurationProperties(persistService.getPropsService().load());
        Map<String, ShardingSphereDatabase> databases = InternalMetaDataFactory.create(persistService, effectiveDatabaseConfigs, props, instanceContext);
        return MetaDataContextsFactory.newMetaDataContexts(persistService, param, globalRuleConfigs, databases, props);
    }

    private static MetaDataContexts newMetaDataContexts(MetaDataPersistService persistService, ContextManagerBuilderParameter param, Collection<RuleConfiguration> globalRuleConfigs, Map<String, ShardingSphereDatabase> databases, ConfigurationProperties props) {
        ResourceMetaData globalResourceMetaData = new ResourceMetaData(param.getGlobalDataSources());
        RuleMetaData globalRuleMetaData = new RuleMetaData(GlobalRulesBuilder.buildRules(globalRuleConfigs, databases.values(), (ConfigurationProperties)props));
        ShardingSphereMetaData metaData = new ShardingSphereMetaData(databases.values(), globalResourceMetaData, globalRuleMetaData, props);
        return new MetaDataContexts(metaData, ShardingSphereStatisticsFactory.create(persistService, metaData));
    }

    private static Collection<String> getDatabaseNames(ComputeNodeInstanceContext instanceContext, Map<String, DatabaseConfiguration> databaseConfigs, MetaDataPersistService persistService) {
        return instanceContext.getInstance().getMetaData() instanceof JDBCInstanceMetaData ? databaseConfigs.keySet() : persistService.getDatabaseMetaDataFacade().getDatabase().loadAllDatabaseNames();
    }

    private static Map<String, DatabaseConfiguration> createEffectiveDatabaseConfigurations(Collection<String> databaseNames, Map<String, DatabaseConfiguration> databaseConfigs, MetaDataPersistService persistService) {
        return databaseNames.stream().collect(Collectors.toMap(each -> each, each -> MetaDataContextsFactory.createEffectiveDatabaseConfiguration(each, databaseConfigs, persistService)));
    }

    private static DatabaseConfiguration createEffectiveDatabaseConfiguration(String databaseName, Map<String, DatabaseConfiguration> databaseConfigs, MetaDataPersistService persistService) {
        MetaDataContextsFactory.closeGeneratedDataSources(databaseName, databaseConfigs);
        Map<String, DataSourceConfiguration> dataSources = persistService.loadDataSourceConfigurations(databaseName);
        Collection<RuleConfiguration> databaseRuleConfigs = persistService.getDatabaseRulePersistService().load(databaseName);
        return new DataSourceGeneratedDatabaseConfiguration(dataSources, databaseRuleConfigs);
    }

    private static void closeGeneratedDataSources(String databaseName, Map<String, ? extends DatabaseConfiguration> databaseConfigs) {
        if (databaseConfigs.containsKey(databaseName) && !databaseConfigs.get(databaseName).getStorageUnits().isEmpty()) {
            databaseConfigs.get(databaseName).getDataSources().values().forEach(each -> new DataSourcePoolDestroyer(each).asyncDestroy());
        }
    }

    private static void persistDatabaseConfigurations(MetaDataContexts metadataContexts, ContextManagerBuilderParameter param, MetaDataPersistService persistService) {
        Collection globalRuleConfigs = metadataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations();
        persistService.persistGlobalRuleConfiguration(globalRuleConfigs, param.getProps());
        for (Map.Entry<String, DatabaseConfiguration> entry : param.getDatabaseConfigs().entrySet()) {
            String databaseName = entry.getKey();
            persistService.persistConfigurations(entry.getKey(), entry.getValue(), metadataContexts.getMetaData().getDatabase(databaseName).getResourceMetaData().getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, each -> ((StorageUnit)each.getValue()).getDataSource(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)), metadataContexts.getMetaData().getDatabase(databaseName).getRuleMetaData().getRules());
        }
    }

    private static void persistMetaData(MetaDataContexts metaDataContexts, MetaDataPersistService persistService) {
        metaDataContexts.getMetaData().getAllDatabases().forEach(each -> each.getAllSchemas().forEach(schema -> {
            if (schema.isEmpty()) {
                persistService.getDatabaseMetaDataFacade().getSchema().add(each.getName(), schema.getName());
            }
            persistService.getDatabaseMetaDataFacade().getTable().persist(each.getName(), schema.getName(), schema.getAllTables());
        }));
        for (Map.Entry databaseDataEntry : metaDataContexts.getStatistics().getDatabaseData().entrySet()) {
            for (Map.Entry schemaDataEntry : ((ShardingSphereDatabaseData)databaseDataEntry.getValue()).getSchemaData().entrySet()) {
                persistService.getShardingSphereDataPersistService().persist(metaDataContexts.getMetaData().getDatabase((String)databaseDataEntry.getKey()), (String)schemaDataEntry.getKey(), (ShardingSphereSchemaData)schemaDataEntry.getValue());
            }
        }
    }

    public static MetaDataContexts createBySwitchResource(String databaseName, boolean internalLoadMetaData, SwitchingResource switchingResource, MetaDataContexts originalMetaDataContexts, MetaDataPersistService persistService, ComputeNodeInstanceContext instanceContext) throws SQLException {
        ShardingSphereDatabase changedDatabase = MetaDataContextsFactory.createChangedDatabase(databaseName, internalLoadMetaData, switchingResource, null, originalMetaDataContexts, persistService, instanceContext);
        ConfigurationProperties props = originalMetaDataContexts.getMetaData().getProps();
        ShardingSphereMetaData clonedMetaData = MetaDataContextsFactory.cloneMetaData(originalMetaDataContexts.getMetaData(), changedDatabase);
        RuleMetaData changedGlobalMetaData = new RuleMetaData(GlobalRulesBuilder.buildRules((Collection)originalMetaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), (Collection)clonedMetaData.getAllDatabases(), (ConfigurationProperties)props));
        ShardingSphereMetaData metaData = new ShardingSphereMetaData(clonedMetaData.getAllDatabases(), originalMetaDataContexts.getMetaData().getGlobalResourceMetaData(), changedGlobalMetaData, props);
        return new MetaDataContexts(metaData, ShardingSphereStatisticsFactory.create(persistService, metaData));
    }

    public static MetaDataContexts createByAlterRule(String databaseName, boolean internalLoadMetaData, Collection<RuleConfiguration> ruleConfigs, MetaDataContexts originalMetaDataContexts, MetaDataPersistService persistService, ComputeNodeInstanceContext instanceContext) throws SQLException {
        ShardingSphereDatabase changedDatabase = MetaDataContextsFactory.createChangedDatabase(databaseName, internalLoadMetaData, null, ruleConfigs, originalMetaDataContexts, persistService, instanceContext);
        ShardingSphereMetaData clonedMetaData = MetaDataContextsFactory.cloneMetaData(originalMetaDataContexts.getMetaData(), changedDatabase);
        ConfigurationProperties props = originalMetaDataContexts.getMetaData().getProps();
        RuleMetaData changedGlobalMetaData = new RuleMetaData(GlobalRulesBuilder.buildRules((Collection)originalMetaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations(), (Collection)clonedMetaData.getAllDatabases(), (ConfigurationProperties)props));
        ShardingSphereMetaData metaData = new ShardingSphereMetaData(clonedMetaData.getAllDatabases(), originalMetaDataContexts.getMetaData().getGlobalResourceMetaData(), changedGlobalMetaData, props);
        return new MetaDataContexts(metaData, ShardingSphereStatisticsFactory.create(persistService, metaData));
    }

    private static ShardingSphereMetaData cloneMetaData(ShardingSphereMetaData originalMetaData, ShardingSphereDatabase changedDatabase) {
        ShardingSphereMetaData result = new ShardingSphereMetaData(originalMetaData.getAllDatabases(), originalMetaData.getGlobalResourceMetaData(), originalMetaData.getGlobalRuleMetaData(), originalMetaData.getProps());
        result.putDatabase(changedDatabase);
        return result;
    }

    public static ShardingSphereDatabase createChangedDatabase(String databaseName, boolean internalLoadMetaData, SwitchingResource switchingResource, Collection<RuleConfiguration> ruleConfigs, MetaDataContexts originalMetaDataContext, MetaDataPersistService persistService, ComputeNodeInstanceContext instanceContext) throws SQLException {
        ResourceMetaData effectiveResourceMetaData = MetaDataContextsFactory.getEffectiveResourceMetaData(originalMetaDataContext.getMetaData().getDatabase(databaseName), switchingResource);
        Collection toBeCreatedRuleConfigs = null == ruleConfigs ? originalMetaDataContext.getMetaData().getDatabase(databaseName).getRuleMetaData().getConfigurations() : ruleConfigs;
        DatabaseConfiguration toBeCreatedDatabaseConfig = MetaDataContextsFactory.getDatabaseConfiguration(effectiveResourceMetaData, switchingResource, toBeCreatedRuleConfigs);
        return MetaDataContextsFactory.createChangedDatabase(originalMetaDataContext.getMetaData().getDatabase(databaseName).getName(), internalLoadMetaData, persistService, toBeCreatedDatabaseConfig, originalMetaDataContext.getMetaData().getProps(), instanceContext);
    }

    private static ShardingSphereDatabase createChangedDatabase(String databaseName, boolean internalLoadMetaData, MetaDataPersistService persistService, DatabaseConfiguration databaseConfig, ConfigurationProperties props, ComputeNodeInstanceContext instanceContext) throws SQLException {
        return internalLoadMetaData ? InternalMetaDataFactory.create(databaseName, persistService, databaseConfig, props, instanceContext) : ExternalMetaDataFactory.create(databaseName, databaseConfig, props, instanceContext);
    }

    private static ResourceMetaData getEffectiveResourceMetaData(ShardingSphereDatabase database, SwitchingResource resource) {
        Map<StorageNode, DataSource> storageNodes = MetaDataContextsFactory.getStorageNodes(database.getResourceMetaData().getDataSources(), resource);
        Map<String, StorageUnit> storageUnits = MetaDataContextsFactory.getStorageUnits(database.getResourceMetaData().getStorageUnits(), resource);
        return new ResourceMetaData(storageNodes, storageUnits);
    }

    private static Map<StorageNode, DataSource> getStorageNodes(Map<StorageNode, DataSource> currentStorageNodes, SwitchingResource resource) {
        LinkedHashMap<StorageNode, DataSource> result = new LinkedHashMap<StorageNode, DataSource>(currentStorageNodes.size(), 1.0f);
        for (Map.Entry<StorageNode, DataSource> entry : currentStorageNodes.entrySet()) {
            if (null != resource && resource.getStaleDataSources().containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static Map<String, StorageUnit> getStorageUnits(Map<String, StorageUnit> currentStorageUnits, SwitchingResource resource) {
        LinkedHashMap<String, StorageUnit> result = new LinkedHashMap<String, StorageUnit>(currentStorageUnits.size(), 1.0f);
        for (Map.Entry<String, StorageUnit> entry : currentStorageUnits.entrySet()) {
            if (null != resource && resource.getStaleStorageUnitNames().contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static DatabaseConfiguration getDatabaseConfiguration(ResourceMetaData resourceMetaData, SwitchingResource switchingResource, Collection<RuleConfiguration> toBeCreatedRuleConfigs) {
        Map propsMap = null == switchingResource ? (Map)resourceMetaData.getStorageUnits().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)) : switchingResource.getMergedDataSourcePoolPropertiesMap();
        return new DataSourceProvidedDatabaseConfiguration(MetaDataContextsFactory.getMergedStorageNodeDataSources(resourceMetaData, switchingResource), toBeCreatedRuleConfigs, propsMap);
    }

    private static Map<StorageNode, DataSource> getMergedStorageNodeDataSources(ResourceMetaData currentResourceMetaData, SwitchingResource switchingResource) {
        Map result = currentResourceMetaData.getDataSources();
        if (null != switchingResource && !switchingResource.getNewDataSources().isEmpty()) {
            result.putAll(switchingResource.getNewDataSources());
        }
        return result;
    }

    @Generated
    private MetaDataContextsFactory() {
    }
}

