/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.restful.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.elasticjob.restful.mapping.PathMatcher;

public final class RegexPathMatcher
implements PathMatcher {
    private static final String PATH_SEPARATOR = "/";
    private static final Pattern PATH_PATTERN = Pattern.compile("^/(([^/{}]+|\\{[^/{}]+})(/([^/{}]+|\\{[^/{}]+}))*/?)?$");
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("\\{(?<template>[^/]+)}");
    private static final String TEMPLATE_REGEX = "(?<${template}>[^/]+)";
    private final Map<String, Pattern> patternCache = new ConcurrentHashMap<String, Pattern>();

    @Override
    public Map<String, String> captureVariables(String pathPattern, String path) {
        String pathWithoutQuery;
        Pattern compiled = this.getCompiledPattern(pathPattern);
        Matcher matcher = compiled.matcher(pathWithoutQuery = this.trimUriQuery(path));
        if (!matcher.matches() || 0 == matcher.groupCount()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        for (String variableName : this.extractTemplateNames(pathPattern)) {
            variables.put(variableName, matcher.group(variableName));
        }
        return Collections.unmodifiableMap(variables);
    }

    @Override
    public boolean matches(String pathPattern, String path) {
        return this.getCompiledPattern(pathPattern).matcher(this.trimUriQuery(path)).matches();
    }

    @Override
    public boolean isValidPathPattern(String pathPattern) {
        return PATH_PATTERN.matcher(pathPattern).matches();
    }

    private Pattern getCompiledPattern(String pathPattern) {
        String regexPattern = this.convertToRegexPattern(pathPattern);
        this.patternCache.computeIfAbsent(regexPattern, Pattern::compile);
        return this.patternCache.get(regexPattern);
    }

    private String convertToRegexPattern(String pathPattern) {
        return TEMPLATE_PATTERN.matcher(pathPattern).replaceAll(TEMPLATE_REGEX);
    }

    private List<String> extractTemplateNames(String pathPattern) {
        String[] pathFragments = pathPattern.split(PATH_SEPARATOR);
        ArrayList<String> result = new ArrayList<String>();
        for (String fragment : pathFragments) {
            int start = fragment.indexOf(123);
            int end = fragment.lastIndexOf(125);
            if (-1 == start || -1 == end) continue;
            result.add(fragment.substring(start + 1, end));
        }
        return result;
    }

    private String trimUriQuery(String uri) {
        int index = uri.indexOf(63);
        if (-1 != index) {
            return uri.substring(0, index);
        }
        return uri;
    }
}

