/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class ActiveVmGroups {
    private final ConcurrentMap<Integer, List<VmGroup>> activeVmGroupsMap = new ConcurrentHashMap<Integer, List<VmGroup>>();
    private volatile long lastSetAt = 0L;

    ActiveVmGroups() {
        this.activeVmGroupsMap.put(0, new ArrayList());
    }

    private VmGroup isIn(String vmg, List<VmGroup> list) {
        for (VmGroup g : list) {
            if (!g.getName().equals(vmg)) continue;
            return g;
        }
        return null;
    }

    void setActiveVmGroups(List<String> vmGroups) {
        List oldList = (List)this.activeVmGroupsMap.get(0);
        ArrayList<VmGroup> vmGroupsList = new ArrayList<VmGroup>();
        for (String vmg : vmGroups) {
            VmGroup in = this.isIn(vmg, oldList);
            if (in == null) {
                vmGroupsList.add(new VmGroup(vmg));
                continue;
            }
            vmGroupsList.add(in);
        }
        this.lastSetAt = System.currentTimeMillis();
        this.activeVmGroupsMap.put(0, vmGroupsList);
    }

    long getLastSetAt() {
        return this.lastSetAt;
    }

    boolean isActiveVmGroup(String vmGroupName, boolean strict) {
        List vmGroupList = (List)this.activeVmGroupsMap.get(0);
        if (vmGroupList.isEmpty()) {
            return true;
        }
        if (strict && vmGroupName == null) {
            return false;
        }
        for (VmGroup group : vmGroupList) {
            if (!group.getName().equals(vmGroupName)) continue;
            return true;
        }
        return false;
    }

    long getActivatedAt(String vmGroupName) {
        List vmGroupList = (List)this.activeVmGroupsMap.get(0);
        for (VmGroup group : vmGroupList) {
            if (!group.getName().equals(vmGroupName)) continue;
            return group.getActivatedAt();
        }
        return -1L;
    }

    private static class VmGroup {
        private final long activatedAt = System.currentTimeMillis();
        private final String name;

        private VmGroup(String name) {
            this.name = name;
        }

        private long getActivatedAt() {
            return this.activatedAt;
        }

        private String getName() {
            return this.name;
        }
    }
}

