/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.fenzo.TaskRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PreferentialNamedConsumableResourceSet {
    static final String attributeName = "ResourceSet";
    public static final String CustomResAbsentKey = "CustomResAbsent";
    private final String name;
    private final List<PreferentialNamedConsumableResource> usageBy;

    private static String getResNameVal(String name, TaskRequest request) {
        Map<String, TaskRequest.NamedResourceSetRequest> customNamedResources = request.getCustomNamedResources();
        if (customNamedResources != null) {
            TaskRequest.NamedResourceSetRequest setRequest = customNamedResources.get(name);
            return setRequest == null ? CustomResAbsentKey : setRequest.getResValue();
        }
        return CustomResAbsentKey;
    }

    public PreferentialNamedConsumableResourceSet(String name, int val0, int val1) {
        this.name = name;
        this.usageBy = new ArrayList<PreferentialNamedConsumableResource>(val0);
        for (int i = 0; i < val0; ++i) {
            this.usageBy.add(new PreferentialNamedConsumableResource(i, name, val1));
        }
    }

    public String getName() {
        return this.name;
    }

    ConsumeResult consume(TaskRequest request) {
        return this.consumeIntl(request, false);
    }

    void assign(TaskRequest request) {
        List<ConsumeResult> consumedNamedResources;
        TaskRequest.AssignedResources assignedResources = request.getAssignedResources();
        if (assignedResources != null && (consumedNamedResources = assignedResources.getConsumedNamedResources()) != null && !consumedNamedResources.isEmpty()) {
            for (ConsumeResult consumeResult : consumedNamedResources) {
                if (!this.name.equals(consumeResult.getAttrName())) continue;
                int index = consumeResult.getIndex();
                if (index < 0 || index > this.usageBy.size()) {
                    throw new IllegalStateException("Illegal assignment of namedResource " + this.name + ": has " + this.usageBy.size() + " resource sets, can't assign to index " + index);
                }
                this.usageBy.get(index).consume(consumeResult.getResName(), request);
            }
        }
    }

    double getFitness(TaskRequest request) {
        return this.consumeIntl(request, true).fitness;
    }

    private ConsumeResult consumeIntl(TaskRequest request, boolean skipConsume) {
        PreferentialNamedConsumableResource best = null;
        double bestFitness = 0.0;
        for (PreferentialNamedConsumableResource r : this.usageBy) {
            double f = r.getFitness(request);
            if (f == 0.0 || !(bestFitness < f)) continue;
            best = r;
            bestFitness = f;
        }
        if (!skipConsume) {
            if (best == null) {
                throw new RuntimeException("Unexpected to have no availability for job " + request.getId() + " for consumable resource " + this.name);
            }
            best.consume(request);
        }
        return new ConsumeResult(best == null ? -1 : best.index, best == null ? null : best.attrName, best == null ? null : best.resName, bestFitness);
    }

    boolean release(TaskRequest request) {
        for (PreferentialNamedConsumableResource r : this.usageBy) {
            if (!r.release(request)) continue;
            return true;
        }
        return false;
    }

    int getNumSubResources() {
        return this.usageBy.get(0).getLimit() - 1;
    }

    List<Double> getUsedCounts() {
        ArrayList<Double> counts = new ArrayList<Double>(this.usageBy.size());
        for (PreferentialNamedConsumableResource r : this.usageBy) {
            counts.add(r.getUsedCount());
        }
        return counts;
    }

    public static class PreferentialNamedConsumableResource {
        private final double maxFitness;
        private final int index;
        private final String attrName;
        private String resName = null;
        private final int limit;
        private final Map<String, TaskRequest.NamedResourceSetRequest> usageBy;
        private int usedSubResources = 0;

        PreferentialNamedConsumableResource(int i, String attrName, int limit) {
            this.index = i;
            this.attrName = attrName;
            this.limit = limit;
            this.usageBy = new HashMap<String, TaskRequest.NamedResourceSetRequest>();
            this.maxFitness = (double)limit + 1.0;
        }

        public int getIndex() {
            return this.index;
        }

        public String getResName() {
            return this.resName;
        }

        public int getLimit() {
            return this.limit;
        }

        public Map<String, TaskRequest.NamedResourceSetRequest> getUsageBy() {
            return this.usageBy;
        }

        double getUsedCount() {
            if (this.resName == null) {
                return -1.0;
            }
            return this.usedSubResources;
        }

        double getFitness(TaskRequest request) {
            double subResNeed;
            String r = PreferentialNamedConsumableResourceSet.getResNameVal(this.attrName, request);
            if (this.resName == null) {
                return 0.5 / this.maxFitness;
            }
            if (!this.resName.equals(r)) {
                return 0.0;
            }
            TaskRequest.NamedResourceSetRequest setRequest = request.getCustomNamedResources() == null ? null : request.getCustomNamedResources().get(this.attrName);
            double d = subResNeed = setRequest == null ? 0.0 : (double)setRequest.getNumSubResources();
            if ((double)this.usedSubResources + subResNeed > (double)this.limit) {
                return 0.0;
            }
            return Math.min(1.0, (double)this.usedSubResources + subResNeed + 1.0 / this.maxFitness);
        }

        void consume(TaskRequest request) {
            String r = PreferentialNamedConsumableResourceSet.getResNameVal(this.attrName, request);
            this.consume(r, request);
        }

        void consume(String assignedResName, TaskRequest request) {
            double subResNeed;
            if (this.usageBy.get(request.getId()) != null) {
                return;
            }
            if (this.resName != null && !this.resName.equals(assignedResName)) {
                throw new IllegalStateException(this.getClass().getName() + " already consumed by " + this.resName + ", can't consume for " + assignedResName);
            }
            if (this.resName == null) {
                this.resName = assignedResName;
                this.usageBy.clear();
            }
            TaskRequest.NamedResourceSetRequest setRequest = request.getCustomNamedResources() == null ? null : request.getCustomNamedResources().get(this.attrName);
            double d = subResNeed = setRequest == null ? 0.0 : (double)setRequest.getNumSubResources();
            if ((double)this.usedSubResources + subResNeed > (double)this.limit) {
                throw new RuntimeException(this.getClass().getName() + " already consumed for " + this.resName + " up to the limit of " + this.limit);
            }
            this.usageBy.put(request.getId(), setRequest);
            this.usedSubResources = (int)((double)this.usedSubResources + subResNeed);
        }

        boolean release(TaskRequest request) {
            String r = PreferentialNamedConsumableResourceSet.getResNameVal(this.attrName, request);
            if (this.resName != null && !this.resName.equals(r)) {
                return false;
            }
            TaskRequest.NamedResourceSetRequest removed = this.usageBy.remove(request.getId());
            if (removed == null) {
                return false;
            }
            this.usedSubResources -= removed.getNumSubResources();
            if (this.usageBy.isEmpty()) {
                this.resName = null;
            }
            return true;
        }
    }

    public static class ConsumeResult {
        private final int index;
        private final String attrName;
        private final String resName;
        private final double fitness;

        @JsonCreator
        @JsonIgnoreProperties(ignoreUnknown=true)
        public ConsumeResult(@JsonProperty(value="index") int index, @JsonProperty(value="attrName") String attrName, @JsonProperty(value="resName") String resName, @JsonProperty(value="fitness") double fitness) {
            this.index = index;
            this.attrName = attrName;
            this.resName = resName;
            this.fitness = fitness;
        }

        public int getIndex() {
            return this.index;
        }

        public String getAttrName() {
            return this.attrName;
        }

        public String getResName() {
            return this.resName;
        }

        public double getFitness() {
            return this.fitness;
        }
    }
}

