/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AssignableVirtualMachine;
import com.netflix.fenzo.AutoScaleRule;
import com.netflix.fenzo.InternalVMCloner;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Func1;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VMCollection {
    private static final String defaultGroupName = "DEFAULT";
    private static final Logger logger = LoggerFactory.getLogger(VMCollection.class);
    private final ConcurrentMap<String, ConcurrentMap<String, AssignableVirtualMachine>> vms = new ConcurrentHashMap<String, ConcurrentMap<String, AssignableVirtualMachine>>();
    private final Func1<String, AssignableVirtualMachine> newVmCreator;
    private final String groupingAttrName;

    VMCollection(Func1<String, AssignableVirtualMachine> func1, String groupingAttrName) {
        this.newVmCreator = func1;
        this.groupingAttrName = groupingAttrName;
    }

    Collection<AssignableVirtualMachine> getAllVMs() {
        LinkedList<AssignableVirtualMachine> result = new LinkedList<AssignableVirtualMachine>();
        this.vms.values().forEach(m -> result.addAll(m.values()));
        return result;
    }

    Collection<String> getGroups() {
        return Collections.unmodifiableCollection(this.vms.keySet());
    }

    Map<String, List<String>> clonePseudoVMsForGroups(Map<String, Integer> groupCounts, Func1<String, AutoScaleRule> ruleGetter, Predicate<VirtualMachineLease> vmFilter) {
        if (groupCounts == null || groupCounts.isEmpty()) {
            return Collections.emptyMap();
        }
        InternalVMCloner vmCloner = new InternalVMCloner();
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        long now = System.currentTimeMillis();
        for (String g : groupCounts.keySet()) {
            int max;
            List<AssignableVirtualMachine> vmsList;
            LinkedList<String> hostnames = new LinkedList<String>();
            result.put(g, hostnames);
            ConcurrentMap avmsMap = (ConcurrentMap)this.vms.get(g);
            if (avmsMap == null || (vmsList = avmsMap.values().stream().filter(avm -> vmFilter.test(avm.getCurrTotalLease())).collect(Collectors.toList())) == null || vmsList.isEmpty()) continue;
            VirtualMachineLease lease = vmCloner.getClonedMaxResourcesLease(vmsList);
            if (logger.isDebugEnabled()) {
                logger.debug("Cloned lease cpu={}, mem={}, disk={}, network={}", new Object[]{lease.cpuCores(), lease.memoryMB(), lease.diskMB(), lease.networkMbps()});
                Map<String, Protos.Attribute> attributeMap = lease.getAttributeMap();
                if (attributeMap == null || attributeMap.isEmpty()) {
                    logger.debug("Cloned maxRes lease has empty attributeMap");
                } else {
                    for (Map.Entry<String, Protos.Attribute> entry : attributeMap.entrySet()) {
                        logger.debug("Cloned maxRes lease attribute: " + entry.getKey() + ": " + (entry.getValue() == null ? "null" : entry.getValue().getText().getValue()));
                    }
                }
            }
            int n = groupCounts.get(g);
            AutoScaleRule rule = ruleGetter.call(g);
            if (rule != null && (max = rule.getMaxSize()) < Integer.MAX_VALUE && n > max - vmsList.size()) {
                n = max - vmsList.size();
            }
            for (int i = 0; i < n; ++i) {
                String hostname = this.createHostname(g, i);
                this.addLease(vmCloner.cloneLease(lease, hostname, now));
                if (logger.isDebugEnabled()) {
                    logger.debug("Added cloned lease for " + hostname);
                }
                hostnames.add(hostname);
                this.getVmByName(hostname).ifPresent(AssignableVirtualMachine::updateCurrTotalLease);
            }
        }
        return result;
    }

    private String createHostname(String g, int i) {
        return "FenzoPsueodHost-" + g + "-" + i;
    }

    AssignableVirtualMachine unsafeRemoveVm(String name, String group) {
        ConcurrentMap vmsMap = (ConcurrentMap)this.vms.get(group);
        if (vmsMap != null) {
            return (AssignableVirtualMachine)vmsMap.remove(name);
        }
        return null;
    }

    Optional<AssignableVirtualMachine> getVmByName(String name) {
        return this.vms.values().stream().flatMap(m -> m.values().stream()).filter(avm -> name.equals(avm.getHostname())).findFirst();
    }

    AssignableVirtualMachine create(String host) {
        return this.create(host, defaultGroupName);
    }

    AssignableVirtualMachine create(String host, String group) {
        this.vms.putIfAbsent(group, new ConcurrentHashMap());
        AssignableVirtualMachine prev = null;
        if (!defaultGroupName.equals(group) && this.vms.get(defaultGroupName) != null) {
            prev = (AssignableVirtualMachine)((ConcurrentMap)this.vms.get(defaultGroupName)).remove(host);
        }
        ((ConcurrentMap)this.vms.get(group)).putIfAbsent(host, prev == null ? this.newVmCreator.call(host) : prev);
        return (AssignableVirtualMachine)((ConcurrentMap)this.vms.get(group)).get(host);
    }

    AssignableVirtualMachine getOrCreate(String host) {
        Optional<AssignableVirtualMachine> vmByName = this.getVmByName(host);
        if (vmByName.isPresent()) {
            return vmByName.get();
        }
        return this.create(host, defaultGroupName);
    }

    private AssignableVirtualMachine getOrCreate(String host, String group) {
        this.vms.putIfAbsent(group, new ConcurrentHashMap());
        AssignableVirtualMachine avm = (AssignableVirtualMachine)((ConcurrentMap)this.vms.get(group)).get(host);
        if (avm != null) {
            return avm;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new host " + host);
        }
        return this.create(host, group);
    }

    boolean addLease(VirtualMachineLease l) {
        String group;
        String string = l.getAttributeMap() == null ? null : (group = l.getAttributeMap().get(this.groupingAttrName) == null ? null : l.getAttributeMap().get(this.groupingAttrName).getText().getValue());
        if (group == null) {
            group = defaultGroupName;
        }
        AssignableVirtualMachine avm = this.getOrCreate(l.hostname(), group);
        return avm.addLease(l);
    }

    public int size() {
        Optional<Integer> size = this.vms.values().stream().map(Map::size).reduce((i1, i2) -> i1 + i2);
        return size.orElse(0);
    }

    public int size(String group) {
        ConcurrentMap m = (ConcurrentMap)this.vms.get(group);
        return m == null ? 0 : m.size();
    }

    public AssignableVirtualMachine remove(AssignableVirtualMachine avm) {
        ConcurrentMap m;
        String group = avm.getAttrValue(this.groupingAttrName);
        AssignableVirtualMachine removed = null;
        if (group != null && (m = (ConcurrentMap)this.vms.get(group)) != null) {
            removed = (AssignableVirtualMachine)m.remove(avm.getHostname());
        }
        if (removed != null) {
            return removed;
        }
        m = (ConcurrentMap)this.vms.get(defaultGroupName);
        if (m != null) {
            m.remove(avm.getHostname());
        }
        return null;
    }
}

