/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.plugins;

import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.VirtualMachineCurrentState;
import java.util.List;

public class WeightedAverageFitnessCalculator
implements VMTaskFitnessCalculator {
    private final List<WeightedFitnessCalculator> calculators;

    public WeightedAverageFitnessCalculator(List<WeightedFitnessCalculator> calculators) {
        this.calculators = calculators;
        if (calculators == null || calculators.isEmpty()) {
            throw new IllegalArgumentException("There must be at least 1 calculator");
        }
        double sum = calculators.stream().map(WeightedFitnessCalculator::getWeight).mapToDouble(Double::doubleValue).sum();
        if (sum != 1.0) {
            throw new IllegalArgumentException("The sum of the weights must equal 1.0");
        }
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
        double totalWeightedScores = 0.0;
        double totalWeights = 0.0;
        for (WeightedFitnessCalculator calculator : this.calculators) {
            double score = calculator.getFitnessCalculator().calculateFitness(taskRequest, targetVM, taskTrackerState);
            if (score == 0.0) {
                return score;
            }
            totalWeightedScores += score * calculator.getWeight();
            totalWeights += calculator.getWeight();
        }
        return totalWeightedScores / totalWeights;
    }

    public String toString() {
        return "Weighted Average Fitness Calculator: " + this.calculators;
    }

    public static class WeightedFitnessCalculator {
        private final VMTaskFitnessCalculator fitnessCalculator;
        private final double weight;

        public WeightedFitnessCalculator(VMTaskFitnessCalculator fitnessCalculator, double weight) {
            if (fitnessCalculator == null) {
                throw new IllegalArgumentException("Fitness Calculator cannot be null");
            }
            this.fitnessCalculator = fitnessCalculator;
            this.weight = weight;
        }

        public VMTaskFitnessCalculator getFitnessCalculator() {
            return this.fitnessCalculator;
        }

        public double getWeight() {
            return this.weight;
        }

        public String toString() {
            return "{ fitnessCalculator: " + this.fitnessCalculator.getName() + ", weight: " + this.weight + " }";
        }
    }
}

