/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.sla;

import com.netflix.fenzo.sla.ResAllocs;

public class ResAllocsBuilder {
    private double cores = Double.MAX_VALUE;
    private double memory = Double.MAX_VALUE;
    private double networkMbps = Double.MAX_VALUE;
    private double disk = Double.MAX_VALUE;
    private final String taskGroupName;

    public ResAllocsBuilder(String taskGroupName) {
        this.taskGroupName = taskGroupName;
    }

    public ResAllocsBuilder withCores(double cores) {
        this.cores = cores;
        return this;
    }

    public ResAllocsBuilder withMemory(double memory) {
        this.memory = memory;
        return this;
    }

    public ResAllocsBuilder withNetworkMbps(double networkMbps) {
        this.networkMbps = networkMbps;
        return this;
    }

    public ResAllocsBuilder withDisk(double disk) {
        this.disk = disk;
        return this;
    }

    public ResAllocs build() {
        return new ResAllocsImpl(this.taskGroupName, this.cores, this.memory, this.networkMbps, this.disk);
    }

    private static class ResAllocsImpl
    implements ResAllocs {
        private final String taskGroupName;
        private final double cores;
        private final double memory;
        private final double networkMbps;
        private final double disk;

        private ResAllocsImpl(String taskGroupName, double cores, double memory, double networkMbps, double disk) {
            this.taskGroupName = taskGroupName;
            this.cores = cores;
            this.memory = memory;
            this.networkMbps = networkMbps;
            this.disk = disk;
        }

        @Override
        public String getTaskGroupName() {
            return this.taskGroupName;
        }

        @Override
        public double getCores() {
            return this.cores;
        }

        @Override
        public double getMemory() {
            return this.memory;
        }

        @Override
        public double getNetworkMbps() {
            return this.networkMbps;
        }

        @Override
        public double getDisk() {
            return this.disk;
        }

        public String toString() {
            return "ResAllocsImpl{taskGroupName='" + this.taskGroupName + '\'' + ", cores=" + this.cores + ", memory=" + this.memory + ", networkMbps=" + this.networkMbps + ", disk=" + this.disk + '}';
        }
    }
}

