/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos;

import com.google.common.util.concurrent.Service;
import com.netflix.fenzo.TaskScheduler;
import java.util.Optional;
import lombok.Generated;
import org.apache.mesos.MesosSchedulerDriver;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;
import org.apache.shardingsphere.elasticjob.cloud.console.ConsoleBootstrap;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.app.CloudAppConfigurationListener;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationListener;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.BootstrapEnvironment;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.MesosConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.ha.FrameworkIDService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.FacadeService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.ReconcileService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.SchedulerEngine;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.TaskLaunchScheduledService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.producer.ProducerManager;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.app.CloudAppDisableListener;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.disable.job.CloudJobDisableListener;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.StatisticManager;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.tracing.JobTracingEventBus;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchedulerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchedulerService.class);
    private static final String WEB_UI_PROTOCOL = "http://";
    private final BootstrapEnvironment env;
    private final FacadeService facadeService;
    private final SchedulerDriver schedulerDriver;
    private final ProducerManager producerManager;
    private final StatisticManager statisticManager;
    private final CloudJobConfigurationListener cloudJobConfigurationListener;
    private final Service taskLaunchScheduledService;
    private final ConsoleBootstrap consoleBootstrap;
    private final ReconcileService reconcileService;
    private final CloudJobDisableListener cloudJobDisableListener;
    private final CloudAppConfigurationListener cloudAppConfigurationListener;
    private final CloudAppDisableListener cloudAppDisableListener;

    public SchedulerService(CoordinatorRegistryCenter regCenter) {
        this.env = BootstrapEnvironment.getINSTANCE();
        this.facadeService = new FacadeService(regCenter);
        this.statisticManager = StatisticManager.getInstance(regCenter, this.env.getTracingConfiguration().orElse(null));
        TaskScheduler taskScheduler = this.getTaskScheduler();
        JobTracingEventBus jobTracingEventBus = this.getJobTracingEventBus();
        this.schedulerDriver = this.getSchedulerDriver(taskScheduler, jobTracingEventBus, new FrameworkIDService(regCenter));
        this.producerManager = new ProducerManager(this.schedulerDriver, regCenter);
        this.cloudJobConfigurationListener = new CloudJobConfigurationListener(regCenter, this.producerManager);
        this.cloudJobDisableListener = new CloudJobDisableListener(regCenter, this.producerManager);
        this.cloudAppConfigurationListener = new CloudAppConfigurationListener(regCenter, this.producerManager);
        this.cloudAppDisableListener = new CloudAppDisableListener(regCenter, this.producerManager);
        this.taskLaunchScheduledService = new TaskLaunchScheduledService(this.schedulerDriver, taskScheduler, this.facadeService, jobTracingEventBus);
        this.reconcileService = new ReconcileService(this.schedulerDriver, this.facadeService);
        this.consoleBootstrap = new ConsoleBootstrap(regCenter, this.env.getRestfulServerConfiguration(), this.producerManager, this.reconcileService);
    }

    private SchedulerDriver getSchedulerDriver(TaskScheduler taskScheduler, JobTracingEventBus jobTracingEventBus, FrameworkIDService frameworkIDService) {
        Protos.FrameworkInfo.Builder builder = Protos.FrameworkInfo.newBuilder();
        frameworkIDService.fetch().ifPresent(frameworkID -> builder.setId(Protos.FrameworkID.newBuilder().setValue(frameworkID).build()));
        Optional<String> role = this.env.getMesosRole();
        String frameworkName = "ElasticJob-Cloud";
        if (role.isPresent()) {
            builder.setRole(role.get());
            frameworkName = frameworkName + "-" + role.get();
        }
        builder.addCapabilitiesBuilder().setType(Protos.FrameworkInfo.Capability.Type.PARTITION_AWARE);
        MesosConfiguration mesosConfig = this.env.getMesosConfiguration();
        Protos.FrameworkInfo frameworkInfo = builder.setUser(mesosConfig.getUser()).setName(frameworkName).setHostname(mesosConfig.getHostname()).setFailoverTimeout(604800.0).setWebuiUrl(WEB_UI_PROTOCOL + this.env.getFrameworkHostPort()).setCheckpoint(true).build();
        return new MesosSchedulerDriver((Scheduler)new SchedulerEngine(taskScheduler, this.facadeService, jobTracingEventBus, frameworkIDService, this.statisticManager), frameworkInfo, mesosConfig.getUrl());
    }

    private TaskScheduler getTaskScheduler() {
        return new TaskScheduler.Builder().withLeaseOfferExpirySecs(1000000000L).withLeaseRejectAction(lease -> {
            log.warn("Declining offer on '{}'", (Object)lease.hostname());
            this.schedulerDriver.declineOffer(lease.getOffer().getId());
        }).build();
    }

    private JobTracingEventBus getJobTracingEventBus() {
        Optional<TracingConfiguration<?>> tracingConfiguration = this.env.getTracingConfiguration();
        return tracingConfiguration.map(JobTracingEventBus::new).orElseGet(JobTracingEventBus::new);
    }

    public void start() {
        this.facadeService.start();
        this.producerManager.startup();
        this.statisticManager.startup();
        this.cloudJobConfigurationListener.start();
        this.cloudAppConfigurationListener.start();
        this.cloudJobDisableListener.start();
        this.cloudAppDisableListener.start();
        this.taskLaunchScheduledService.startAsync();
        this.consoleBootstrap.start();
        this.schedulerDriver.start();
        if (this.env.getFrameworkConfiguration().isEnabledReconcile()) {
            this.reconcileService.startAsync();
        }
    }

    public void stop() {
        this.consoleBootstrap.stop();
        this.taskLaunchScheduledService.stopAsync();
        this.cloudJobConfigurationListener.stop();
        this.cloudAppConfigurationListener.stop();
        this.cloudJobDisableListener.stop();
        this.cloudAppDisableListener.stop();
        this.statisticManager.shutdown();
        this.producerManager.shutdown();
        this.schedulerDriver.stop(true);
        this.facadeService.stop();
        if (this.env.getFrameworkConfiguration().isEnabledReconcile()) {
            this.reconcileService.stopAsync();
        }
    }

    @Generated
    public SchedulerService(BootstrapEnvironment env, FacadeService facadeService, SchedulerDriver schedulerDriver, ProducerManager producerManager, StatisticManager statisticManager, CloudJobConfigurationListener cloudJobConfigurationListener, Service taskLaunchScheduledService, ConsoleBootstrap consoleBootstrap, ReconcileService reconcileService, CloudJobDisableListener cloudJobDisableListener, CloudAppConfigurationListener cloudAppConfigurationListener, CloudAppDisableListener cloudAppDisableListener) {
        this.env = env;
        this.facadeService = facadeService;
        this.schedulerDriver = schedulerDriver;
        this.producerManager = producerManager;
        this.statisticManager = statisticManager;
        this.cloudJobConfigurationListener = cloudJobConfigurationListener;
        this.taskLaunchScheduledService = taskLaunchScheduledService;
        this.consoleBootstrap = consoleBootstrap;
        this.reconcileService = reconcileService;
        this.cloudJobDisableListener = cloudJobDisableListener;
        this.cloudAppConfigurationListener = cloudAppConfigurationListener;
        this.cloudAppDisableListener = cloudAppDisableListener;
    }
}

