/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.batch;

import java.util.List;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.logging.Logger;
import org.mybatis.logging.LoggerFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.util.Assert;

public class MyBatisBatchItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyBatisBatchItemWriter.class);
    private SqlSessionTemplate sqlSessionTemplate;
    private String statementId;
    private boolean assertUpdates = true;
    private Converter<T, ?> itemToParameterConverter = new PassThroughConverter();

    public void setAssertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        if (this.sqlSessionTemplate == null) {
            this.sqlSessionTemplate = new SqlSessionTemplate(sqlSessionFactory, ExecutorType.BATCH);
        }
    }

    public void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.sqlSessionTemplate = sqlSessionTemplate;
    }

    public void setStatementId(String statementId) {
        this.statementId = statementId;
    }

    public void setItemToParameterConverter(Converter<T, ?> itemToParameterConverter) {
        this.itemToParameterConverter = itemToParameterConverter;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.sqlSessionTemplate, (String)"A SqlSessionFactory or a SqlSessionTemplate is required.");
        Assert.isTrue((ExecutorType.BATCH == this.sqlSessionTemplate.getExecutorType() ? 1 : 0) != 0, (String)"SqlSessionTemplate's executor type must be BATCH");
        Assert.notNull((Object)this.statementId, (String)"A statementId is required.");
        Assert.notNull(this.itemToParameterConverter, (String)"A itemToParameterConverter is required.");
    }

    public void write(Chunk<? extends T> items) {
        if (!items.isEmpty()) {
            LOGGER.debug(() -> "Executing batch with " + items.size() + " items.");
            for (Object item : items) {
                this.sqlSessionTemplate.update(this.statementId, this.itemToParameterConverter.convert(item));
            }
            List<BatchResult> results = this.sqlSessionTemplate.flushStatements();
            if (this.assertUpdates) {
                if (results.size() != 1) {
                    throw new InvalidDataAccessResourceUsageException("Batch execution returned invalid results. Expected 1 but number of BatchResult objects returned was " + results.size());
                }
                int[] updateCounts = results.get(0).getUpdateCounts();
                for (int i = 0; i < updateCounts.length; ++i) {
                    int value = updateCounts[i];
                    if (value != 0) continue;
                    throw new EmptyResultDataAccessException("Item " + i + " of " + updateCounts.length + " did not update any rows: [" + items.getItems().get(i) + "]", 1);
                }
            }
        }
    }

    private static class PassThroughConverter<T>
    implements Converter<T, T> {
        private PassThroughConverter() {
        }

        public T convert(T source) {
            return source;
        }
    }
}

