/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.mapper.DiscoveryHandlerMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.DiscoveryUpstreamService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@RestApi(value={"/discovery-upstream"})
public class DiscoveryUpstreamController {
    private final DiscoveryUpstreamService discoveryUpstreamService;

    public DiscoveryUpstreamController(DiscoveryUpstreamService discoveryUpstreamService) {
        this.discoveryUpstreamService = discoveryUpstreamService;
    }

    @PostMapping
    public ShenyuAdminResult createDiscoveryUpstream(@Valid @RequestBody DiscoveryUpstreamDTO discoveryUpstreamDTO) {
        return ShenyuAdminResult.success(this.discoveryUpstreamService.createOrUpdate(discoveryUpstreamDTO));
    }

    @PostMapping(value={"batch"})
    public ShenyuAdminResult createDiscoveryUpstreamList(@Valid @RequestBody List<DiscoveryUpstreamDTO> discoveryUpstreamDTOList) {
        if (CollectionUtils.isNotEmpty(discoveryUpstreamDTOList)) {
            for (DiscoveryUpstreamDTO discoveryUpstreamDTO : discoveryUpstreamDTOList) {
                this.discoveryUpstreamService.createOrUpdate(discoveryUpstreamDTO);
            }
        }
        return ShenyuAdminResult.success();
    }

    @PutMapping(value={"/{discoveryHandlerId}"})
    public ShenyuAdminResult updateDiscoveryUpstream(@PathVariable(value="discoveryHandlerId") @Existed(message="discovery upstream is not existed", provider=DiscoveryHandlerMapper.class) @Existed(message="discovery upstream is not existed", provider=DiscoveryHandlerMapper.class) String discoveryHandlerId, @Valid @RequestBody List<DiscoveryUpstreamDTO> discoveryUpstreamDTO) {
        return ShenyuAdminResult.success(this.discoveryUpstreamService.updateBatch(discoveryHandlerId, discoveryUpstreamDTO));
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteDiscoveryUpstream(@NotEmpty @RequestBody List<@NotBlank String> ids) {
        return ShenyuAdminResult.success(this.discoveryUpstreamService.delete(ids));
    }
}

