/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.composite.trigger;

import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.circuitbreaker.composite.trigger.CounterOptions;
import com.tencent.polaris.plugins.circuitbreaker.composite.trigger.TriggerCounter;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class ConsecutiveCounter
extends TriggerCounter {
    private static final Logger LOG = LoggerFactory.getLogger(ConsecutiveCounter.class);
    private final AtomicInteger consecutiveErrors = new AtomicInteger(0);
    private int maxCount;

    public ConsecutiveCounter(String ruleName, CounterOptions counterOptions) {
        super(ruleName, counterOptions);
    }

    @Override
    protected void init() {
        LOG.info("[CircuitBreaker][Counter] consecutiveCounter {} initialized, resource {}", (Object)this.ruleName, (Object)this.resource);
        this.maxCount = this.triggerCondition.getErrorCount();
    }

    @Override
    public void report(boolean success) {
        if (this.suspended.get()) {
            return;
        }
        if (!success) {
            int currentSum = this.consecutiveErrors.incrementAndGet();
            if (currentSum == this.maxCount) {
                this.suspend();
                this.consecutiveErrors.set(0);
                this.statusChangeHandler.closeToOpen(this.ruleName);
                return;
            }
        } else {
            this.consecutiveErrors.set(0);
        }
    }
}

