/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.flow.cache.expired;

import com.tencent.polaris.plugins.flow.cache.expired.PluginCacheItem;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class PluginCacheValues {
    private final Map<Object, PluginCacheItem> values = new ConcurrentHashMap<Object, PluginCacheItem>();

    public <T> T getOrCreateValue(Object key, final Function<Object, T> createFunc) {
        PluginCacheItem pluginCacheItem = this.values.get(key);
        if (null != pluginCacheItem) {
            return (T)pluginCacheItem.getValue();
        }
        pluginCacheItem = this.values.computeIfAbsent(key, new Function<Object, PluginCacheItem>(){

            @Override
            public PluginCacheItem apply(Object o) {
                return new PluginCacheItem(o, createFunc.apply(o));
            }
        });
        return (T)pluginCacheItem.getValue();
    }

    public void expireValues(long expireDuration) {
        long curTimeMs = System.currentTimeMillis();
        for (PluginCacheItem item : this.values.values()) {
            if (curTimeMs - item.getLastAccessTime() < expireDuration) continue;
            this.values.remove(item.getKey());
        }
    }
}

