/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.pulsar.client;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.logging.common.client.AbstractLogConsumeClient;
import org.apache.shenyu.plugin.logging.common.entity.LZ4CompressData;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.pulsar.config.PulsarLogCollectConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class PulsarLogCollectClient
extends AbstractLogConsumeClient<PulsarLogCollectConfig.PulsarLogConfig, ShenyuRequestLog> {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarLogCollectClient.class);
    private PulsarClient client;
    private Producer<byte[]> producer;

    public void initClient0(@NonNull PulsarLogCollectConfig.PulsarLogConfig config) {
        String topic = config.getTopic();
        String serviceUrl = config.getServiceUrl();
        if (StringUtils.isBlank((CharSequence)topic) || StringUtils.isBlank((CharSequence)serviceUrl)) {
            LOG.error("init PulsarLogCollectClient error, please check topic or serviceUrl.");
            return;
        }
        try {
            this.client = PulsarClient.builder().serviceUrl(serviceUrl).build();
            this.producer = this.client.newProducer().topic(topic).create();
            LOG.info("init PulsarLogCollectClient success.");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((PulsarLogCollectClient)this).close()));
        }
        catch (PulsarClientException e) {
            LOG.error("init PulsarLogCollectClient error, ", (Throwable)e);
        }
    }

    public void consume0(@NonNull List<ShenyuRequestLog> logs) {
        logs.forEach(log -> this.producer.sendAsync((Object)this.toBytes((ShenyuRequestLog)log)));
    }

    private byte[] toBytes(ShenyuRequestLog log) {
        byte[] bytes = JsonUtils.toJson((Object)log).getBytes(StandardCharsets.UTF_8);
        String compressAlg = (String)StringUtils.defaultIfBlank((CharSequence)PulsarLogCollectConfig.INSTANCE.getPulsarLogConfig().getCompressAlg(), (CharSequence)"");
        if ("LZ4".equalsIgnoreCase(compressAlg.trim())) {
            LZ4CompressData lz4CompressData = new LZ4CompressData(bytes.length, this.compressedByte(bytes));
            return JsonUtils.toJson((Object)lz4CompressData).getBytes(StandardCharsets.UTF_8);
        }
        return bytes;
    }

    private byte[] compressedByte(byte[] srcByte) {
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4Compressor compressor = factory.fastCompressor();
        return compressor.compress(srcByte);
    }

    public void close0() {
        if (Objects.nonNull(this.producer)) {
            try {
                this.producer.close();
                this.client.close();
            }
            catch (PulsarClientException e) {
                LOG.error("fail to close PulsarLogCollectClient, e", (Throwable)e);
            }
        }
    }
}

