/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client.transport;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.modelcontextprotocol.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class ServerParameters {
    private static final List<String> DEFAULT_INHERITED_ENV_VARS = System.getProperty("os.name").toLowerCase().contains("win") ? Arrays.asList("APPDATA", "HOMEDRIVE", "HOMEPATH", "LOCALAPPDATA", "PATH", "PROCESSOR_ARCHITECTURE", "SYSTEMDRIVE", "SYSTEMROOT", "TEMP", "USERNAME", "USERPROFILE") : Arrays.asList("HOME", "LOGNAME", "PATH", "SHELL", "TERM", "USER");
    @JsonProperty(value="command")
    private String command;
    @JsonProperty(value="args")
    private List<String> args = new ArrayList<String>();
    @JsonProperty(value="env")
    private Map<String, String> env;

    private ServerParameters(String command, List<String> args, Map<String, String> env) {
        Assert.notNull(command, "The command can not be null");
        Assert.notNull(args, "The args can not be null");
        this.command = command;
        this.args = args;
        this.env = new HashMap<String, String>(ServerParameters.getDefaultEnvironment());
        if (env != null && !env.isEmpty()) {
            this.env.putAll(env);
        }
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public static Builder builder(String command) {
        return new Builder(command);
    }

    private static Map<String, String> getDefaultEnvironment() {
        return System.getenv().entrySet().stream().filter(entry -> DEFAULT_INHERITED_ENV_VARS.contains(entry.getKey())).filter(entry -> entry.getValue() != null).filter(entry -> !((String)entry.getValue()).startsWith("()")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static class Builder {
        private String command;
        private List<String> args = new ArrayList<String>();
        private Map<String, String> env = new HashMap<String, String>();

        public Builder(String command) {
            Assert.notNull(command, "The command can not be null");
            this.command = command;
        }

        public Builder args(String ... args) {
            Assert.notNull(args, "The args can not be null");
            this.args = Arrays.asList(args);
            return this;
        }

        public Builder args(List<String> args) {
            Assert.notNull(args, "The args can not be null");
            this.args = new ArrayList<String>(args);
            return this;
        }

        public Builder arg(String arg) {
            Assert.notNull(arg, "The arg can not be null");
            this.args.add(arg);
            return this;
        }

        public Builder env(Map<String, String> env) {
            if (env != null && !env.isEmpty()) {
                this.env.putAll(env);
            }
            return this;
        }

        public Builder addEnvVar(String key, String value) {
            Assert.notNull(key, "The key can not be null");
            Assert.notNull(value, "The value can not be null");
            this.env.put(key, value);
            return this;
        }

        public ServerParameters build() {
            return new ServerParameters(this.command, this.args, this.env);
        }
    }
}

