/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.reporter.Call;
import zipkin2.reporter.HttpEndpointSupplier;

public final class HttpEndpointSuppliers {
    public static HttpEndpointSupplier.Factory constantFactory() {
        return ConstantFactory.INSTANCE;
    }

    public static HttpEndpointSupplier.Constant newConstant(String endpoint) {
        if (endpoint == null) {
            throw new NullPointerException("endpoint == null");
        }
        return new Constant(endpoint);
    }

    public static HttpEndpointSupplier.Factory newRateLimitedFactory(HttpEndpointSupplier.Factory input, int intervalSeconds) {
        if (input == null) {
            throw new NullPointerException("input == null");
        }
        if (intervalSeconds < 1) {
            throw new IllegalArgumentException("intervalSeconds < 1");
        }
        if (input == ConstantFactory.INSTANCE) {
            return input;
        }
        return new RateLimited.Factory(input, intervalSeconds);
    }

    public static HttpEndpointSupplier newRateLimited(HttpEndpointSupplier input, int intervalSeconds) {
        if (input == null) {
            throw new NullPointerException("input == null");
        }
        if (intervalSeconds < 1) {
            throw new IllegalArgumentException("intervalSeconds < 1");
        }
        if (input instanceof HttpEndpointSupplier.Constant) {
            return input;
        }
        return new RateLimited(RateLimited.LOGGER, input, intervalSeconds);
    }

    static class RateLimited
    implements HttpEndpointSupplier {
        static final Logger LOGGER = Logger.getLogger(RateLimited.class.getName());
        final Logger logger;
        final HttpEndpointSupplier delegate;
        final int intervalSeconds;
        String endpoint;
        long nanoTimeout;

        RateLimited(Logger logger, HttpEndpointSupplier delegate, int intervalSeconds) {
            this.logger = logger;
            this.delegate = delegate;
            this.intervalSeconds = intervalSeconds;
            this.endpoint = delegate.get();
            this.updateNextGet();
        }

        long nanoTime() {
            return System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final synchronized String get() {
            long nanoTimeout;
            long now = this.nanoTime();
            long nanosUntilGet = -(now - (nanoTimeout = this.nanoTimeout));
            if (nanosUntilGet <= 0L) {
                try {
                    this.endpoint = this.delegate.get();
                }
                catch (Throwable t) {
                    Call.propagateIfFatal(t);
                    String message = String.format("error from httpEndpointSupplier.get() will retry in %ds: %s", this.intervalSeconds, t.getMessage());
                    this.logger.warning(message);
                    this.logger.log(Level.FINE, "exception from: " + this.delegate, t);
                }
                finally {
                    this.updateNextGet();
                }
            }
            return this.endpoint;
        }

        private void updateNextGet() {
            this.nanoTimeout = this.nanoTime() + TimeUnit.SECONDS.toNanos(this.intervalSeconds);
        }

        @Override
        public final void close() throws IOException {
            this.delegate.close();
        }

        public String toString() {
            return "RateLimited{delegate=" + this.delegate + ", intervalSeconds=" + this.intervalSeconds + "}";
        }

        static final class Factory
        implements HttpEndpointSupplier.Factory {
            final HttpEndpointSupplier.Factory delegate;
            final int intervalSeconds;

            Factory(HttpEndpointSupplier.Factory delegate, int intervalSeconds) {
                this.delegate = delegate;
                this.intervalSeconds = intervalSeconds;
            }

            @Override
            public HttpEndpointSupplier create(String endpoint) {
                return HttpEndpointSuppliers.newRateLimited(this.delegate.create(endpoint), this.intervalSeconds);
            }

            public String toString() {
                return "RateLimited{delegate=" + this.delegate + ", intervalSeconds=" + this.intervalSeconds + "}";
            }
        }
    }

    static final class Constant
    implements HttpEndpointSupplier.Constant {
        final String endpoint;

        Constant(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public String get() {
            return this.endpoint;
        }

        @Override
        public void close() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpEndpointSupplier.Constant)) {
                return false;
            }
            HttpEndpointSupplier.Constant that = (HttpEndpointSupplier.Constant)o;
            return this.endpoint.equals(that.get());
        }

        public int hashCode() {
            return this.endpoint.hashCode();
        }

        public String toString() {
            return this.endpoint;
        }
    }

    static enum ConstantFactory implements HttpEndpointSupplier.Factory
    {
        INSTANCE;


        @Override
        public HttpEndpointSupplier create(String endpoint) {
            return HttpEndpointSuppliers.newConstant(endpoint);
        }

        public String toString() {
            return "ConstantFactory{}";
        }
    }
}

