/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.rest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.metadata.rest.PathMatcher;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.protocol.rest.exception.DoublePathCheckException;
import org.apache.dubbo.rpc.protocol.rest.pair.InvokerAndRestMethodMetadataPair;

public class PathAndInvokerMapper {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(PathAndInvokerMapper.class);
    private final Map<PathMatcher, InvokerAndRestMethodMetadataPair> pathToServiceMapContainPathVariable = new ConcurrentHashMap<PathMatcher, InvokerAndRestMethodMetadataPair>();
    private final Map<PathMatcher, InvokerAndRestMethodMetadataPair> pathToServiceMapNoPathVariable = new ConcurrentHashMap<PathMatcher, InvokerAndRestMethodMetadataPair>();
    private final Map<PathMatcher, Set<String>> pathMatcherToHttpMethodMap = new HashMap<PathMatcher, Set<String>>();

    public void addPathAndInvoker(Map<PathMatcher, RestMethodMetadata> metadataMap, Invoker invoker) {
        metadataMap.entrySet().stream().forEach(entry -> {
            PathMatcher pathMatcher = (PathMatcher)entry.getKey();
            if (pathMatcher.hasPathVariable()) {
                this.addPathMatcherToPathMap(pathMatcher, this.pathToServiceMapContainPathVariable, InvokerAndRestMethodMetadataPair.pair(invoker, (RestMethodMetadata)entry.getValue()));
            } else {
                this.addPathMatcherToPathMap(pathMatcher, this.pathToServiceMapNoPathVariable, InvokerAndRestMethodMetadataPair.pair(invoker, (RestMethodMetadata)entry.getValue()));
            }
        });
    }

    public InvokerAndRestMethodMetadataPair getRestMethodMetadata(PathMatcher pathMatcher) {
        if (this.pathToServiceMapNoPathVariable.containsKey(pathMatcher)) {
            return this.pathToServiceMapNoPathVariable.get(pathMatcher);
        }
        if (this.pathToServiceMapContainPathVariable.containsKey(pathMatcher)) {
            return this.pathToServiceMapContainPathVariable.get(pathMatcher);
        }
        return null;
    }

    public void removePath(PathMatcher pathMatcher) {
        InvokerAndRestMethodMetadataPair containPathVariablePair = this.pathToServiceMapContainPathVariable.remove(pathMatcher);
        InvokerAndRestMethodMetadataPair unContainPathVariablePair = this.pathToServiceMapNoPathVariable.remove(pathMatcher);
        logger.info("dubbo rest undeploy pathMatcher:" + pathMatcher + ", and path variable method is :" + (containPathVariablePair == null ? null : containPathVariablePair.getRestMethodMetadata().getReflectMethod()) + ", and no path variable  method is :" + (unContainPathVariablePair == null ? null : unContainPathVariablePair.getRestMethodMetadata().getReflectMethod()));
    }

    public void addPathMatcherToPathMap(PathMatcher pathMatcher, Map<PathMatcher, InvokerAndRestMethodMetadataPair> pathMatcherPairMap, InvokerAndRestMethodMetadataPair invokerRestMethodMetadataPair) {
        InvokerAndRestMethodMetadataPair beforeMetadata;
        if (pathMatcherPairMap.containsKey(pathMatcher) && !invokerRestMethodMetadataPair.compareServiceMethod(beforeMetadata = pathMatcherPairMap.get(pathMatcher))) {
            throw new DoublePathCheckException("dubbo rest double path check error, current path is: " + pathMatcher + " ,and service method is: " + invokerRestMethodMetadataPair.getRestMethodMetadata().getReflectMethod() + "before service  method is: " + beforeMetadata.getRestMethodMetadata().getReflectMethod());
        }
        pathMatcherPairMap.put(pathMatcher, invokerRestMethodMetadataPair);
        this.addPathMatcherToHttpMethodsMap(pathMatcher);
        logger.info("dubbo rest deploy pathMatcher:" + pathMatcher + ", and service method is :" + invokerRestMethodMetadataPair.getRestMethodMetadata().getReflectMethod());
    }

    private void addPathMatcherToHttpMethodsMap(PathMatcher pathMatcher) {
        Set<Object> httpMethods;
        PathMatcher newPathMatcher = PathMatcher.convertPathMatcher(pathMatcher);
        if (!this.pathMatcherToHttpMethodMap.containsKey(newPathMatcher)) {
            httpMethods = new HashSet<String>();
            ((HashSet)httpMethods).add(pathMatcher.getHttpMethod());
            this.pathMatcherToHttpMethodMap.put(newPathMatcher, httpMethods);
        }
        httpMethods = this.pathMatcherToHttpMethodMap.get(newPathMatcher);
        httpMethods.add(newPathMatcher.getHttpMethod());
    }

    public boolean isHttpMethodAllowed(PathMatcher pathMatcher) {
        PathMatcher newPathMatcher = PathMatcher.convertPathMatcher(pathMatcher);
        if (!this.pathMatcherToHttpMethodMap.containsKey(newPathMatcher)) {
            return false;
        }
        Set<String> httpMethods = this.pathMatcherToHttpMethodMap.get(newPathMatcher);
        return httpMethods.contains(newPathMatcher.getHttpMethod());
    }

    public String pathHttpMethods(PathMatcher pathMatcher) {
        PathMatcher newPathMatcher = PathMatcher.convertPathMatcher(pathMatcher);
        if (!this.pathMatcherToHttpMethodMap.containsKey(newPathMatcher)) {
            return null;
        }
        Set<String> httpMethods = this.pathMatcherToHttpMethodMap.get(newPathMatcher);
        return httpMethods.toString();
    }
}

