/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.handler;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.plugin.base.handler.DiscoveryUpstreamDataHandler;
import org.apache.shenyu.plugin.grpc.cache.ApplicationConfigCache;
import org.apache.shenyu.plugin.grpc.cache.GrpcClientCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class GrpcDiscoveryUpstreamDataHandler
implements DiscoveryUpstreamDataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcDiscoveryUpstreamDataHandler.class);

    public void handlerDiscoveryUpstreamData(DiscoverySyncData discoverySyncData) {
        if (Objects.isNull(discoverySyncData) || Objects.isNull(discoverySyncData.getSelectorId())) {
            return;
        }
        LOG.info("discovery grpc upstream data:{}", (Object)JsonUtils.toJson((Object)discoverySyncData));
        String selectorId = discoverySyncData.getSelectorId();
        List<GrpcUpstream> upstreams = this.convertUpstreamList(discoverySyncData.getUpstreamDataList());
        List<GrpcUpstream> grayUpstreamList = upstreams.stream().filter(CommonUpstream::isGray).toList();
        if (!grayUpstreamList.isEmpty()) {
            ApplicationConfigCache.getInstance().handlerUpstream(discoverySyncData.getSelectorId(), grayUpstreamList);
        } else {
            ApplicationConfigCache.getInstance().handlerUpstream(discoverySyncData.getSelectorId(), upstreams);
        }
        GrpcClientCache.initGrpcClient(selectorId);
    }

    private List<GrpcUpstream> convertUpstreamList(List<DiscoveryUpstreamData> upstreamList) {
        if (ObjectUtils.isEmpty(upstreamList)) {
            return Collections.emptyList();
        }
        return upstreamList.stream().map(u -> GrpcUpstream.builder().protocol(u.getProtocol()).upstreamUrl(u.getUrl()).weight(u.getWeight()).status(0 == u.getStatus()).timestamp(Optional.ofNullable(u.getDateCreated()).map(Timestamp::getTime).orElse(System.currentTimeMillis()).longValue()).build()).collect(Collectors.toList());
    }

    public String pluginName() {
        return PluginEnum.GRPC.getName();
    }
}

