/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Anomaly;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetRecordsResponse
implements JsonpSerializable {
    private final long count;
    private final List<Anomaly> records;
    public static final JsonpDeserializer<GetRecordsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetRecordsResponse::setupGetRecordsResponseDeserializer);

    private GetRecordsResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.records = ApiTypeHelper.unmodifiableRequired(builder.records, (Object)this, "records");
    }

    public static GetRecordsResponse of(Function<Builder, ObjectBuilder<GetRecordsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<Anomaly> records() {
        return this.records;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.records)) {
            generator.writeKey("records");
            generator.writeStartArray();
            for (Anomaly item0 : this.records) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetRecordsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::records, JsonpDeserializer.arrayDeserializer(Anomaly._DESERIALIZER), "records");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetRecordsResponse> {
        private Long count;
        private List<Anomaly> records;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder records(List<Anomaly> list) {
            this.records = Builder._listAddAll(this.records, list);
            return this;
        }

        public final Builder records(Anomaly value, Anomaly ... values) {
            this.records = Builder._listAdd(this.records, value, values);
            return this;
        }

        public final Builder records(Function<Anomaly.Builder, ObjectBuilder<Anomaly>> fn) {
            return this.records(fn.apply(new Anomaly.Builder()).build(), new Anomaly[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetRecordsResponse build() {
            this._checkSingleUse();
            return new GetRecordsResponse(this);
        }
    }
}

