// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

use std::io::Error;

/// Shenyu Error.
#[derive(Debug)]
pub struct ShenYuError {
    /// The error code.
    pub code: i32,
    /// The error message.
    pub message: String,
}

impl ShenYuError {
    /// Create a new `ShenYuError`.
    #[must_use]
    pub fn new(code: i32, message: String) -> Self {
        Self { code, message }
    }
}

impl From<ShenYuError> for Error {
    fn from(val: ShenYuError) -> Self {
        Error::new(std::io::ErrorKind::Other, val.message)
    }
}
