/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.Pruner;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.xml.NilReason;

@XmlTransient
public abstract class AbstractMetadata
implements LenientComparable,
Emptiable {
    transient HashMap<Integer, NilReason> nilReasons;

    protected AbstractMetadata() {
    }

    protected AbstractMetadata(Object source) {
        if (source instanceof AbstractMetadata) {
            this.nilReasons = ((AbstractMetadata)source).nilReasons;
            if (this.nilReasons != null) {
                this.nilReasons = (HashMap)this.nilReasons.clone();
            }
        }
    }

    public abstract MetadataStandard getStandard();

    public Class<?> getInterface() {
        return this.getStandard().getInterface(this.getClass());
    }

    public boolean isEmpty() {
        return Pruner.isEmpty(this, false);
    }

    public void prune() {
        Pruner.isEmpty(this, true);
    }

    public Map<String, Object> asMap() {
        return this.getStandard().asValueMap(this, null, KeyNamePolicy.JAVABEANS_PROPERTY, ValueExistencePolicy.NON_EMPTY);
    }

    public Map<String, NilReason> nilReasons() {
        return this.getStandard().asNilReasonMap(this, null, KeyNamePolicy.JAVABEANS_PROPERTY);
    }

    public TreeTable asTreeTable() {
        return this.getStandard().asTreeTable(this, null, ValueExistencePolicy.COMPACT);
    }

    public boolean equals(Object object, ComparisonMode mode) {
        return this.getStandard().equals(this, object, mode);
    }

    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        return this.getStandard().hashCode(this);
    }

    public String toString() {
        return this.asTreeTable().toString();
    }

    protected AbstractMetadata clone() throws CloneNotSupportedException {
        AbstractMetadata clone = (AbstractMetadata)super.clone();
        if (clone.nilReasons != null) {
            clone.nilReasons = (HashMap)clone.nilReasons.clone();
        }
        return clone;
    }
}

