/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.internal.shared;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.apache.sis.xml.bind.Context;

public final class ImplementationHelper {
    public static final String ISO_NAMESPACE = "http://standards.iso.org/iso/";

    private ImplementationHelper() {
    }

    public static boolean nonNil(Object value) {
        return value != null && !(value instanceof NilObject);
    }

    public static Collection<?> valueIfDefined(Collection<?> value) {
        return value == null || value.isEmpty() ? null : value;
    }

    public static boolean ensurePositive(Class<?> classe, String property, boolean strict, Number newValue) throws IllegalArgumentException {
        if (newValue != null) {
            double value = newValue.doubleValue();
            if (!(!strict ? value >= 0.0 : value > 0.0) && NilReason.forObject(newValue) == null) {
                String msg = ImplementationHelper.logOrFormat(classe, property, strict ? (short)203 : 117, property, newValue);
                if (msg != null) {
                    throw new IllegalArgumentException(msg);
                }
                return false;
            }
        }
        return true;
    }

    public static boolean ensureInRange(Class<?> classe, String property, Number minimum, Number maximum, Number newValue) throws IllegalArgumentException {
        double value;
        if (!(newValue == null || (value = newValue.doubleValue()) >= minimum.doubleValue() && value <= maximum.doubleValue() || NilReason.forObject(newValue) != null)) {
            String msg = ImplementationHelper.logOrFormat(classe, property, (short)204, property, minimum, maximum, newValue);
            if (msg != null) {
                throw new IllegalArgumentException(msg);
            }
            return false;
        }
        return true;
    }

    private static String logOrFormat(Class<?> classe, String property, short key, Object ... arguments) {
        Context context = Context.current();
        if (context == null) {
            return Errors.format((short)key, (Object)arguments);
        }
        StringBuilder buffer = new StringBuilder(property.length() + 3).append("set").append(property);
        buffer.setCharAt(3, Character.toUpperCase(buffer.charAt(3)));
        Context.warningOccured(context, classe, buffer.toString(), Errors.class, key, arguments);
        return null;
    }

    public static void propertyAlreadySet(Class<?> classe, String method, String name) throws IllegalStateException {
        Context context = Context.current();
        if (context == null) {
            throw new IllegalStateException(Errors.format((short)42, (Object)name));
        }
        Context.warningOccured(context, classe, method, Errors.class, (short)42, name);
    }

    public static <T> Collection<T> setFirst(Collection<T> values, T newValue) {
        if (values == null) {
            return CollectionsExt.singletonOrEmpty(newValue);
        }
        if (newValue == null) {
            Iterator<T> it = values.iterator();
            if (it.hasNext()) {
                it.next();
                it.remove();
            }
        } else if (values.isEmpty()) {
            values.add(newValue);
        } else {
            if (!(values instanceof List)) {
                values = new ArrayList<T>(values);
            }
            ((List)values).set(0, newValue);
        }
        return values;
    }

    public static String getObjectID(IdentifiedObject object) {
        Context context = Context.current();
        String id = Context.getObjectID(context, object);
        if (id == null && (id = object.getIdentifierMap().getSpecialized(IdentifierSpace.ID)) != null) {
            StringBuilder buffer = new StringBuilder();
            if (!Strings.appendUnicodeIdentifier((StringBuilder)buffer, (char)'\u0000', (String)id, (String)":-", (boolean)false)) {
                return null;
            }
            id = buffer.toString();
            if (!Context.setObjectForID(context, object, id)) {
                int s = buffer.append('-').length();
                int n = 0;
                do {
                    if (++n == 100) {
                        return null;
                    }
                    id = buffer.append(n).toString();
                    buffer.setLength(s);
                } while (!Context.setObjectForID(context, object, id));
            }
        }
        return id;
    }

    public static void setObjectID(IdentifiedObject object, String id) {
        if ((id = Strings.trimOrNull((String)id)) != null) {
            object.getIdentifierMap().putSpecialized(IdentifierSpace.ID, id);
            Context context = Context.current();
            if (!Context.setObjectForID(context, object, id)) {
                Context.warningOccured(context, object.getClass(), "setID", Errors.class, (short)39, id);
            }
        }
    }
}

