/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import jakarta.xml.bind.Unmarshaller;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.UUID;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.MarshallerPool;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilObjectHandler;
import org.apache.sis.xml.Pooled;
import org.apache.sis.xml.XLink;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gcx.Anchor;
import org.apache.sis.xml.internal.shared.ExternalLinkHandler;
import org.apache.sis.xml.internal.shared.URISource;
import org.apache.sis.xml.internal.shared.XmlUtilities;
import org.opengis.metadata.Identifier;

public class ReferenceResolver {
    public static final ReferenceResolver DEFAULT = new ReferenceResolver();
    protected final URIResolver externalSourceResolver;

    protected ReferenceResolver() {
        this.externalSourceResolver = null;
    }

    public ReferenceResolver(URIResolver externalSourceResolver) {
        this.externalSourceResolver = externalSourceResolver;
    }

    public <T> T newIdentifiedObject(MarshalContext context, Class<T> type, Identifier ... identifiers) {
        if (NilObjectHandler.isIgnoredInterface(type)) {
            throw new IllegalArgumentException(Errors.format((short)59, (Object)"type", type));
        }
        return (T)Proxy.newProxyInstance(ReferenceResolver.class.getClassLoader(), new Class[]{type, IdentifiedObject.class, NilObject.class, LenientComparable.class}, (InvocationHandler)new NilObjectHandler(identifiers));
    }

    public <T> T resolve(MarshalContext context, Class<T> type, UUID uuid) {
        ArgumentChecks.ensureNonNull((String)"type", type);
        ArgumentChecks.ensureNonNull((String)"uuid", (Object)uuid);
        return null;
    }

    public <T> T resolve(MarshalContext context, Class<T> type, XLink link) {
        Object[] args;
        short key;
        short reasonIfNull;
        Object object;
        Context c;
        ArgumentChecks.ensureNonNull((String)"type", type);
        ArgumentChecks.ensureNonNull((String)"xlink", (Object)link);
        URI href = link.getHRef();
        if (href == null || href.isOpaque()) {
            return null;
        }
        Context context2 = c = context instanceof Context ? (Context)context : Context.current();
        if (!href.isAbsolute() && Strings.isNullOrEmpty((String)href.getPath())) {
            String fragment = Strings.trimOrNull((String)href.getFragment());
            if (fragment == null) {
                return null;
            }
            object = Context.getObjectForID(c, fragment);
            reasonIfNull = 134;
        } else {
            try {
                Object base;
                ExternalLinkHandler handler = Context.linkHandler(c);
                Source source = null;
                if (this.externalSourceResolver != null && (base = handler.getBase()) != null) {
                    source = this.externalSourceResolver.resolve(href.toString(), base.toString());
                }
                if (source == null && (source = handler.openReader(href)) == null) {
                    reasonIfNull = 22;
                    object = null;
                } else {
                    object = this.resolveExternal(context, source);
                    reasonIfNull = 0;
                }
            }
            catch (Exception e) {
                ExternalLinkHandler.warningOccured(href, e);
                return null;
            }
        }
        if (type.isInstance(object)) {
            return type.cast(object);
        }
        if (object == null) {
            if (reasonIfNull == 0) {
                return null;
            }
            key = reasonIfNull;
            args = new Object[]{href.toString()};
        } else {
            key = 175;
            args = new Object[]{href.toString(), type, object.getClass()};
        }
        Context.warningOccured(c, ReferenceResolver.class, "resolve", Errors.class, key, args);
        return null;
    }

    protected Object resolveExternal(MarshalContext context, Source source) throws Exception {
        Object object;
        Object object2;
        Context c;
        String fragment;
        Object document;
        URI uri;
        if (source instanceof URISource) {
            URISource s = (URISource)source;
            uri = s.getReadableURI();
            document = s.document;
            fragment = s.fragment;
        } else {
            int s;
            uri = null;
            String systemId = source.getSystemId();
            if (systemId != null && (s = systemId.lastIndexOf(35)) >= 0) {
                document = Strings.trimOrNull((String)systemId.substring(0, s));
                fragment = Strings.trimOrNull((String)systemId.substring(s + 1));
            } else {
                document = systemId;
                fragment = null;
            }
        }
        Context context2 = c = context instanceof Context ? (Context)context : Context.current();
        if (c != null && (object2 = c.getExternalObjectForID(document, fragment)) != null) {
            XmlUtilities.close(source);
            return object2 != Context.INVALID_OBJECT ? object2 : null;
        }
        MarshallerPool pool = context.getPool();
        Unmarshaller m = pool.acquireUnmarshaller();
        if (m instanceof Pooled) {
            ((Pooled)m).forIncludedDocument(document);
        }
        try {
            object = uri != null ? m.unmarshal(uri.toURL()) : m.unmarshal(source);
        }
        catch (Exception e) {
            if (c != null) {
                c.cacheDocument(document, Context.INVALID_OBJECT);
            }
            throw e;
        }
        pool.recycle(m);
        if (c != null) {
            Object part;
            c.cacheDocument(document, object);
            if (fragment != null && ((part = c.getExternalObjectForID(document, fragment)) != null || uri != null)) {
                return part;
            }
        }
        return object;
    }

    public <T> boolean canSubstituteByReference(MarshalContext context, Class<T> type, T object, String id) {
        return true;
    }

    public <T> boolean canSubstituteByReference(MarshalContext context, Class<T> type, T object, UUID uuid) {
        return object instanceof NilObject || object instanceof Emptiable && ((Emptiable)object).isEmpty();
    }

    public <T> boolean canSubstituteByReference(MarshalContext context, Class<T> type, T object, XLink link) {
        return object instanceof NilObject || object instanceof Emptiable && ((Emptiable)object).isEmpty();
    }

    public XLink anchor(MarshalContext context, Object value, CharSequence text) {
        return text instanceof Anchor ? (Anchor)((Object)text) : null;
    }
}

