/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.Spherical3Dto2D;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public final class Spherical2Dto3D
extends AbstractProvider {
    private static final long serialVersionUID = -2320384527305401074L;
    public static final String NAME = "Spherical2D to 3D conversion";
    public static final ParameterDescriptorGroup PARAMETERS;
    private static final Spherical2Dto3D INSTANCE;

    public static Spherical2Dto3D provider() {
        return INSTANCE;
    }

    public Spherical2Dto3D() {
        super(Conversion.class, PARAMETERS, SphericalCS.class, true, SphericalCS.class, false, (byte)2);
    }

    @Override
    public AbstractProvider inverse() {
        return Spherical3Dto2D.provider();
    }

    @Override
    public AbstractProvider variantFor(MathTransform transform) {
        return transform.getSourceDimensions() > transform.getTargetDimensions() ? Spherical3Dto2D.provider() : this;
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        try {
            return this.inverse().createMathTransform(context).inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new FactoryException((Throwable)e);
        }
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)Spherical2Dto3D.builder().setCodeSpace(Citations.SIS, "SIS");
        PARAMETERS = ((ParameterBuilder)builder.addName(NAME)).createGroupForMapProjection(new ParameterDescriptor[0]);
        INSTANCE = new Spherical2Dto3D();
    }
}

