/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.referencing.gazetteer.FinalLocationType;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.referencing.gazetteer.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.util.InternationalString;

abstract class AbstractLocationType
implements LenientComparable {
    protected AbstractLocationType() {
    }

    public static List<AbstractLocationType> snapshot(ReferencingByIdentifiers rs, AbstractLocationType ... types) {
        ArgumentChecks.ensureNonNull((String)"types", (Object)types);
        List<AbstractLocationType> snapshot = FinalLocationType.snapshot(Arrays.asList(types), rs, new IdentityHashMap<AbstractLocationType, FinalLocationType>());
        IdentityHashMap<AbstractLocationType, Boolean> parents = new IdentityHashMap<AbstractLocationType, Boolean>();
        for (AbstractLocationType type : snapshot) {
            AbstractLocationType.checkForCycles(type, parents);
        }
        return snapshot;
    }

    private static void checkForCycles(AbstractLocationType type, Map<AbstractLocationType, Boolean> parents) {
        if (parents.put(type, Boolean.TRUE) != null) {
            throw new IllegalArgumentException(Resources.format((short)11, type.getName()));
        }
        for (AbstractLocationType abstractLocationType : type.getChildren()) {
            AbstractLocationType.checkForCycles(abstractLocationType, parents);
        }
        parents.remove(type);
    }

    final void checkForCycles() {
        AbstractLocationType.checkForCycles(this, new IdentityHashMap<AbstractLocationType, Boolean>());
    }

    public abstract InternationalString getName();

    public abstract InternationalString getTheme();

    public abstract Collection<? extends InternationalString> getIdentifications();

    public abstract InternationalString getDefinition();

    public abstract GeographicExtent getTerritoryOfUse();

    public abstract ReferencingByIdentifiers getReferenceSystem();

    public abstract AbstractParty getOwner();

    public abstract Collection<? extends AbstractLocationType> getParents();

    public abstract Collection<? extends AbstractLocationType> getChildren();

    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            switch (mode) {
                case STRICT: {
                    if (this.getClass() != object.getClass()) break;
                }
                case BY_CONTRACT: {
                    if (!(object instanceof AbstractLocationType)) break;
                    AbstractLocationType that = (AbstractLocationType)object;
                    if (!Utilities.deepEquals((Object)this.getTheme(), (Object)that.getTheme(), (ComparisonMode)mode) || !Utilities.deepEquals(this.getIdentifications(), that.getIdentifications(), (ComparisonMode)mode) || !Utilities.deepEquals((Object)this.getDefinition(), (Object)that.getDefinition(), (ComparisonMode)mode) || !Utilities.deepEquals((Object)this.getTerritoryOfUse(), (Object)that.getTerritoryOfUse(), (ComparisonMode)mode) || !Utilities.deepEquals((Object)this.getOwner(), (Object)that.getOwner(), (ComparisonMode)mode)) break;
                }
                default: {
                    if (!(object instanceof AbstractLocationType)) break;
                    AbstractLocationType that = (AbstractLocationType)object;
                    if (!Objects.equals(this.getName(), that.getName())) break;
                    return Utilities.deepEquals(this.getChildren(), that.getChildren(), (ComparisonMode)mode);
                }
            }
        }
        return false;
    }

    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        int code = Objects.hashCode(this.getName());
        for (AbstractLocationType abstractLocationType : this.getChildren()) {
            code = code * 31 + Objects.hashCode(abstractLocationType.getName());
        }
        return code;
    }

    public String toString() {
        DefaultTreeTable table = new DefaultTreeTable(new TableColumn[]{TableColumn.NAME, TableColumn.VALUE_AS_TEXT});
        AbstractLocationType.format(this, table.getRoot());
        return table.toString();
    }

    private static void format(AbstractLocationType type, TreeTable.Node node) {
        node.setValue(TableColumn.NAME, (Object)type.getName());
        node.setValue(TableColumn.VALUE_AS_TEXT, (Object)type.getDefinition());
        for (AbstractLocationType abstractLocationType : type.getChildren()) {
            AbstractLocationType.format(abstractLocationType, node.newChild());
        }
    }
}

