/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.file.AggregatedHttpFile;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.HttpFileAttributes;
import com.linecorp.armeria.server.file.NonExistentAggregatedHttpFile;
import io.netty.buffer.ByteBufAllocator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

final class NonExistentHttpFile
implements HttpFile {
    static final NonExistentHttpFile INSTANCE = new NonExistentHttpFile(null);
    private static final CompletableFuture<AggregatedHttpFile> AGGREGATED_FUTURE = UnmodifiableFuture.completedFuture(NonExistentAggregatedHttpFile.INSTANCE);
    @Nullable
    private final String location;

    NonExistentHttpFile(@Nullable String location) {
        this.location = location;
    }

    @Override
    public CompletableFuture<HttpFileAttributes> readAttributes(Executor fileReadExecutor) {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<ResponseHeaders> readHeaders(Executor fileReadExecutor) {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<HttpResponse> read(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public HttpService asService() {
        return (ctx, req) -> {
            switch (req.method()) {
                case HEAD: 
                case GET: {
                    if (this.location == null) {
                        return HttpResponse.of(HttpStatus.NOT_FOUND);
                    }
                    return HttpResponse.ofRedirect(this.location);
                }
            }
            return HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
        };
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregate(Executor fileReadExecutor) {
        return AGGREGATED_FUTURE;
    }

    @Override
    public CompletableFuture<AggregatedHttpFile> aggregateWithPooledObjects(Executor fileReadExecutor, ByteBufAllocator alloc) {
        return AGGREGATED_FUTURE;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

