/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.restapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.logging.v3.LogTags;
import org.apache.skywalking.generator.Generator;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.core.source.Log;
import org.apache.skywalking.restapi.TagGenerator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public final class LogRequest
implements Generator<Object, Log> {
    @JsonIgnore
    private final ObjectMapper om = new ObjectMapper();
    private Generator<Object, Long> timestamp;
    private Generator<Object, String> serviceName;
    private Generator<Object, String> serviceInstanceName;
    private Generator<Object, String> endpointName;
    private Generator<Object, String> traceId;
    private Generator<Object, String> traceSegmentId;
    private Generator<Object, Long> spanId;
    private Generator<Object, Long> contentType;
    private Generator<Object, String> content;
    private Generator<Object, List<TagGenerator>> tags;
    private Generator<Object, Boolean> error;

    @Override
    public Log next(Object ignored) {
        Log log = new Log();
        if (this.timestamp == null) {
            log.setTimestamp(System.currentTimeMillis());
        } else {
            log.setTimestamp(this.getTimestamp().next(null).longValue());
        }
        log.setServiceId(IDManager.ServiceID.buildId((String)this.getServiceName().next(null), (boolean)true));
        log.setServiceInstanceId(IDManager.ServiceInstanceID.buildId((String)log.getServiceId(), (String)this.getServiceInstanceName().next(null)));
        log.setEndpointId(IDManager.EndpointID.buildId((String)log.getServiceId(), (String)this.getEndpointName().next(null)));
        log.setTraceId(this.getTraceId().next(null));
        log.setTraceSegmentId(this.getTraceSegmentId().next(null));
        log.setSpanId(this.getSpanId().next(null).intValue());
        log.setContentType(ContentType.instanceOf((int)this.getContentType().next(null).intValue()));
        log.setContent(this.getContent().next(null));
        log.setError(this.getError().next(null).booleanValue());
        log.setTimeBucket(TimeBucket.getRecordTimeBucket((long)log.getTimestamp()));
        log.setTags(this.getTags().next(null).stream().map(tg -> tg.next((Object)null)).collect(Collectors.toList()));
        log.setTagsRawData(LogTags.newBuilder().addAllData((Iterable)log.getTags().stream().map(it -> KeyStringValuePair.newBuilder().setKey(it.getKey()).setValue(it.getValue()).build()).collect(Collectors.toList())).build().toByteArray());
        log.setUniqueId(UUID.randomUUID().toString());
        return log;
    }

    @Generated
    public LogRequest() {
    }

    @Generated
    public ObjectMapper getOm() {
        return this.om;
    }

    @Generated
    public Generator<Object, Long> getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Generator<Object, String> getServiceName() {
        return this.serviceName;
    }

    @Generated
    public Generator<Object, String> getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public Generator<Object, String> getEndpointName() {
        return this.endpointName;
    }

    @Generated
    public Generator<Object, String> getTraceId() {
        return this.traceId;
    }

    @Generated
    public Generator<Object, String> getTraceSegmentId() {
        return this.traceSegmentId;
    }

    @Generated
    public Generator<Object, Long> getSpanId() {
        return this.spanId;
    }

    @Generated
    public Generator<Object, Long> getContentType() {
        return this.contentType;
    }

    @Generated
    public Generator<Object, String> getContent() {
        return this.content;
    }

    @Generated
    public Generator<Object, List<TagGenerator>> getTags() {
        return this.tags;
    }

    @Generated
    public Generator<Object, Boolean> getError() {
        return this.error;
    }

    @Generated
    public void setTimestamp(Generator<Object, Long> timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setServiceName(Generator<Object, String> serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setServiceInstanceName(Generator<Object, String> serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public void setEndpointName(Generator<Object, String> endpointName) {
        this.endpointName = endpointName;
    }

    @Generated
    public void setTraceId(Generator<Object, String> traceId) {
        this.traceId = traceId;
    }

    @Generated
    public void setTraceSegmentId(Generator<Object, String> traceSegmentId) {
        this.traceSegmentId = traceSegmentId;
    }

    @Generated
    public void setSpanId(Generator<Object, Long> spanId) {
        this.spanId = spanId;
    }

    @Generated
    public void setContentType(Generator<Object, Long> contentType) {
        this.contentType = contentType;
    }

    @Generated
    public void setContent(Generator<Object, String> content) {
        this.content = content;
    }

    @Generated
    public void setTags(Generator<Object, List<TagGenerator>> tags) {
        this.tags = tags;
    }

    @Generated
    public void setError(Generator<Object, Boolean> error) {
        this.error = error;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogRequest)) {
            return false;
        }
        LogRequest other = (LogRequest)o;
        ObjectMapper this$om = this.getOm();
        ObjectMapper other$om = other.getOm();
        if (this$om == null ? other$om != null : !this$om.equals(other$om)) {
            return false;
        }
        Generator<Object, Long> this$timestamp = this.getTimestamp();
        Generator<Object, Long> other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        Generator<Object, String> this$serviceName = this.getServiceName();
        Generator<Object, String> other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        Generator<Object, String> this$serviceInstanceName = this.getServiceInstanceName();
        Generator<Object, String> other$serviceInstanceName = other.getServiceInstanceName();
        if (this$serviceInstanceName == null ? other$serviceInstanceName != null : !this$serviceInstanceName.equals(other$serviceInstanceName)) {
            return false;
        }
        Generator<Object, String> this$endpointName = this.getEndpointName();
        Generator<Object, String> other$endpointName = other.getEndpointName();
        if (this$endpointName == null ? other$endpointName != null : !this$endpointName.equals(other$endpointName)) {
            return false;
        }
        Generator<Object, String> this$traceId = this.getTraceId();
        Generator<Object, String> other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        Generator<Object, String> this$traceSegmentId = this.getTraceSegmentId();
        Generator<Object, String> other$traceSegmentId = other.getTraceSegmentId();
        if (this$traceSegmentId == null ? other$traceSegmentId != null : !this$traceSegmentId.equals(other$traceSegmentId)) {
            return false;
        }
        Generator<Object, Long> this$spanId = this.getSpanId();
        Generator<Object, Long> other$spanId = other.getSpanId();
        if (this$spanId == null ? other$spanId != null : !this$spanId.equals(other$spanId)) {
            return false;
        }
        Generator<Object, Long> this$contentType = this.getContentType();
        Generator<Object, Long> other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        Generator<Object, String> this$content = this.getContent();
        Generator<Object, String> other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Generator<Object, List<TagGenerator>> this$tags = this.getTags();
        Generator<Object, List<TagGenerator>> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) {
            return false;
        }
        Generator<Object, Boolean> this$error = this.getError();
        Generator<Object, Boolean> other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMapper $om = this.getOm();
        result = result * 59 + ($om == null ? 43 : $om.hashCode());
        Generator<Object, Long> $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        Generator<Object, String> $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        Generator<Object, String> $serviceInstanceName = this.getServiceInstanceName();
        result = result * 59 + ($serviceInstanceName == null ? 43 : $serviceInstanceName.hashCode());
        Generator<Object, String> $endpointName = this.getEndpointName();
        result = result * 59 + ($endpointName == null ? 43 : $endpointName.hashCode());
        Generator<Object, String> $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        Generator<Object, String> $traceSegmentId = this.getTraceSegmentId();
        result = result * 59 + ($traceSegmentId == null ? 43 : $traceSegmentId.hashCode());
        Generator<Object, Long> $spanId = this.getSpanId();
        result = result * 59 + ($spanId == null ? 43 : $spanId.hashCode());
        Generator<Object, Long> $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        Generator<Object, String> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Generator<Object, List<TagGenerator>> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        Generator<Object, Boolean> $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LogRequest(om=" + this.getOm() + ", timestamp=" + this.getTimestamp() + ", serviceName=" + this.getServiceName() + ", serviceInstanceName=" + this.getServiceInstanceName() + ", endpointName=" + this.getEndpointName() + ", traceId=" + this.getTraceId() + ", traceSegmentId=" + this.getTraceSegmentId() + ", spanId=" + this.getSpanId() + ", contentType=" + this.getContentType() + ", content=" + this.getContent() + ", tags=" + this.getTags() + ", error=" + this.getError() + ")";
    }
}

