/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.input;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.enumeration.Scope;

public class Entity {
    private Scope scope;
    private String serviceName;
    private Boolean normal;
    private String serviceInstanceName;
    private String endpointName;
    private String processName;
    private String destServiceName;
    private Boolean destNormal;
    private String destServiceInstanceName;
    private String destEndpointName;
    private String destProcessName;

    public boolean isService() {
        return Scope.Service.equals((Object)this.scope);
    }

    public boolean isValid() {
        switch (this.scope) {
            case All: {
                return true;
            }
            case Service: {
                return Objects.nonNull(this.serviceName) && Objects.nonNull(this.normal);
            }
            case ServiceInstance: {
                return Objects.nonNull(this.serviceName) && Objects.nonNull(this.serviceInstanceName) && Objects.nonNull(this.normal);
            }
            case Endpoint: {
                return Objects.nonNull(this.serviceName) && Objects.nonNull(this.endpointName) && Objects.nonNull(this.normal);
            }
            case Process: {
                return Objects.nonNull(this.serviceName) && Objects.nonNull(this.serviceInstanceName) && Objects.nonNull(this.processName) && Objects.nonNull(this.normal);
            }
            case ServiceRelation: {
                return Objects.nonNull(this.serviceName) && Objects.nonNull(this.destServiceName) && Objects.nonNull(this.normal) && Objects.nonNull(this.destNormal);
            }
            case ServiceInstanceRelation: {
                return Objects.nonNull(this.serviceName) && Objects.nonNull(this.destServiceName) && Objects.nonNull(this.serviceInstanceName) && Objects.nonNull(this.destServiceInstanceName) && Objects.nonNull(this.normal) && Objects.nonNull(this.destNormal);
            }
            case EndpointRelation: {
                return Objects.nonNull(this.serviceName) && Objects.nonNull(this.destServiceName) && Objects.nonNull(this.endpointName) && Objects.nonNull(this.destEndpointName) && Objects.nonNull(this.normal) && Objects.nonNull(this.destNormal);
            }
            case ProcessRelation: {
                return Objects.nonNull(this.serviceName) && Objects.nonNull(this.destServiceName) && Objects.nonNull(this.serviceInstanceName) && Objects.nonNull(this.destServiceInstanceName) && Objects.nonNull(this.processName) && Objects.nonNull(this.destProcessName) && Objects.nonNull(this.normal) && Objects.nonNull(this.destNormal);
            }
        }
        return false;
    }

    public String buildId() {
        switch (this.scope) {
            case All: {
                return null;
            }
            case Service: {
                return IDManager.ServiceID.buildId(this.serviceName, this.normal);
            }
            case ServiceInstance: {
                return IDManager.ServiceInstanceID.buildId(IDManager.ServiceID.buildId(this.serviceName, this.normal), this.serviceInstanceName);
            }
            case Endpoint: {
                return IDManager.EndpointID.buildId(IDManager.ServiceID.buildId(this.serviceName, this.normal), this.endpointName);
            }
            case Process: {
                return IDManager.ProcessID.buildId(IDManager.ServiceInstanceID.buildId(IDManager.ServiceID.buildId(this.serviceName, this.normal), this.serviceInstanceName), this.processName);
            }
            case ServiceRelation: {
                return IDManager.ServiceID.buildRelationId(new IDManager.ServiceID.ServiceRelationDefine(IDManager.ServiceID.buildId(this.serviceName, this.normal), IDManager.ServiceID.buildId(this.destServiceName, this.destNormal)));
            }
            case ServiceInstanceRelation: {
                return IDManager.ServiceInstanceID.buildRelationId(new IDManager.ServiceInstanceID.ServiceInstanceRelationDefine(IDManager.ServiceInstanceID.buildId(IDManager.ServiceID.buildId(this.serviceName, this.normal), this.serviceInstanceName), IDManager.ServiceInstanceID.buildId(IDManager.ServiceID.buildId(this.destServiceName, this.destNormal), this.destServiceInstanceName)));
            }
            case EndpointRelation: {
                return IDManager.EndpointID.buildRelationId(new IDManager.EndpointID.EndpointRelationDefine(IDManager.ServiceID.buildId(this.serviceName, this.normal), this.endpointName, IDManager.ServiceID.buildId(this.destServiceName, this.destNormal), this.destEndpointName));
            }
            case ProcessRelation: {
                return IDManager.ProcessID.buildRelationId(new IDManager.ProcessID.ProcessRelationDefine(IDManager.ProcessID.buildId(IDManager.ServiceInstanceID.buildId(IDManager.ServiceID.buildId(this.serviceName, this.normal), this.serviceInstanceName), this.processName), IDManager.ProcessID.buildId(IDManager.ServiceInstanceID.buildId(IDManager.ServiceID.buildId(this.destServiceName, this.destNormal), this.destServiceInstanceName), this.destProcessName)));
            }
        }
        return null;
    }

    @Generated
    public void setScope(Scope scope) {
        this.scope = scope;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setNormal(Boolean normal) {
        this.normal = normal;
    }

    @Generated
    public void setServiceInstanceName(String serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    @Generated
    public void setProcessName(String processName) {
        this.processName = processName;
    }

    @Generated
    public void setDestServiceName(String destServiceName) {
        this.destServiceName = destServiceName;
    }

    @Generated
    public void setDestNormal(Boolean destNormal) {
        this.destNormal = destNormal;
    }

    @Generated
    public void setDestServiceInstanceName(String destServiceInstanceName) {
        this.destServiceInstanceName = destServiceInstanceName;
    }

    @Generated
    public void setDestEndpointName(String destEndpointName) {
        this.destEndpointName = destEndpointName;
    }

    @Generated
    public void setDestProcessName(String destProcessName) {
        this.destProcessName = destProcessName;
    }

    @Generated
    public Scope getScope() {
        return this.scope;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public Boolean getNormal() {
        return this.normal;
    }

    @Generated
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public String getEndpointName() {
        return this.endpointName;
    }

    @Generated
    public String getProcessName() {
        return this.processName;
    }

    @Generated
    public String getDestServiceName() {
        return this.destServiceName;
    }

    @Generated
    public Boolean getDestNormal() {
        return this.destNormal;
    }

    @Generated
    public String getDestServiceInstanceName() {
        return this.destServiceInstanceName;
    }

    @Generated
    public String getDestEndpointName() {
        return this.destEndpointName;
    }

    @Generated
    public String getDestProcessName() {
        return this.destProcessName;
    }

    @Generated
    public String toString() {
        return "Entity(scope=" + this.getScope() + ", serviceName=" + this.getServiceName() + ", normal=" + this.getNormal() + ", serviceInstanceName=" + this.getServiceInstanceName() + ", endpointName=" + this.getEndpointName() + ", processName=" + this.getProcessName() + ", destServiceName=" + this.getDestServiceName() + ", destNormal=" + this.getDestNormal() + ", destServiceInstanceName=" + this.getDestServiceInstanceName() + ", destEndpointName=" + this.getDestEndpointName() + ", destProcessName=" + this.getDestProcessName() + ")";
    }
}

