/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.AbstractDescribedNode;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.IgnoredChars;
import graphql.language.InputValueDefinition;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeDirectivesBuilder;
import graphql.language.NodeVisitor;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

@PublicApi
public class FieldDefinition
extends AbstractDescribedNode<FieldDefinition>
implements DirectivesContainer<FieldDefinition>,
NamedNode<FieldDefinition> {
    private final String name;
    private final Type type;
    private final ImmutableList<InputValueDefinition> inputValueDefinitions;
    private final ImmutableList<Directive> directives;
    public static final String CHILD_TYPE = "type";
    public static final String CHILD_INPUT_VALUE_DEFINITION = "inputValueDefinition";
    public static final String CHILD_DIRECTIVES = "directives";

    @Internal
    protected FieldDefinition(String name, Type type, List<InputValueDefinition> inputValueDefinitions, List<Directive> directives, Description description, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData, description);
        this.name = name;
        this.type = type;
        this.inputValueDefinitions = ImmutableList.copyOf(inputValueDefinitions);
        this.directives = ImmutableList.copyOf(directives);
    }

    public FieldDefinition(String name, Type type) {
        this(name, type, ImmutableKit.emptyList(), ImmutableKit.emptyList(), null, null, ImmutableKit.emptyList(), IgnoredChars.EMPTY, ImmutableKit.emptyMap());
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<InputValueDefinition> getInputValueDefinitions() {
        return this.inputValueDefinitions;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.type);
        result.addAll(this.inputValueDefinitions);
        result.addAll(this.directives);
        return result;
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().child(CHILD_TYPE, this.type).children(CHILD_INPUT_VALUE_DEFINITION, this.inputValueDefinitions).children(CHILD_DIRECTIVES, this.directives).build();
    }

    @Override
    public FieldDefinition withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> builder.type((Type)newChildren.getChildOrNull(CHILD_TYPE)).inputValueDefinitions(newChildren.getChildren(CHILD_INPUT_VALUE_DEFINITION)).directives(newChildren.getChildren(CHILD_DIRECTIVES)));
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDefinition that = (FieldDefinition)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public FieldDefinition deepCopy() {
        return new FieldDefinition(this.name, this.deepCopy(this.type), this.deepCopy(this.inputValueDefinitions), this.deepCopy(this.directives), this.description, this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "FieldDefinition{name='" + this.name + "', type=" + this.type + ", inputValueDefinitions=" + this.inputValueDefinitions + ", directives=" + this.directives + "}";
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitFieldDefinition(this, context);
    }

    public static Builder newFieldDefinition() {
        return new Builder();
    }

    public FieldDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeDirectivesBuilder {
        private SourceLocation sourceLocation;
        private String name;
        private ImmutableList<Comment> comments = ImmutableKit.emptyList();
        private Type type;
        private Description description;
        private ImmutableList<InputValueDefinition> inputValueDefinitions = ImmutableKit.emptyList();
        private ImmutableList<Directive> directives = ImmutableKit.emptyList();
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(FieldDefinition existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.name = existing.getName();
            this.comments = ImmutableList.copyOf(existing.getComments());
            this.type = existing.getType();
            this.description = existing.getDescription();
            this.inputValueDefinitions = ImmutableList.copyOf(existing.getInputValueDefinitions());
            this.directives = ImmutableList.copyOf(existing.getDirectives());
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = ImmutableList.copyOf(comments);
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder description(Description description) {
            this.description = description;
            return this;
        }

        public Builder inputValueDefinitions(List<InputValueDefinition> inputValueDefinitions) {
            this.inputValueDefinitions = ImmutableList.copyOf(inputValueDefinitions);
            return this;
        }

        public Builder inputValueDefinition(InputValueDefinition inputValueDefinition) {
            this.inputValueDefinitions = ImmutableKit.addToList(this.inputValueDefinitions, inputValueDefinition, new InputValueDefinition[0]);
            return this;
        }

        @Override
        public Builder directives(List<Directive> directives) {
            this.directives = ImmutableList.copyOf(directives);
            return this;
        }

        @Override
        public Builder directive(Directive directive) {
            this.directives = ImmutableKit.addToList(this.directives, directive, new Directive[0]);
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public FieldDefinition build() {
            return new FieldDefinition(this.name, this.type, this.inputValueDefinitions, this.directives, this.description, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

