/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.bulk;

import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearch;
import org.apache.skywalking.library.elasticsearch.bulk.BulkProcessorBuilder;
import org.apache.skywalking.library.elasticsearch.requests.IndexRequest;
import org.apache.skywalking.library.elasticsearch.requests.UpdateRequest;
import org.apache.skywalking.library.elasticsearch.requests.factory.Codec;
import org.apache.skywalking.library.elasticsearch.requests.factory.RequestFactory;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.RunnableWithExceptionProtection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BulkProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkProcessor.class);
    private final ArrayBlockingQueue<Holder> requests;
    private final AtomicReference<ElasticSearch> es;
    private final int bulkActions;
    private final Semaphore semaphore;
    private final long flushInternalInMillis;
    private volatile long lastFlushTS = 0L;
    private final int batchOfBytes;

    public static BulkProcessorBuilder builder() {
        return new BulkProcessorBuilder();
    }

    BulkProcessor(AtomicReference<ElasticSearch> es, int bulkActions, Duration flushInterval, int concurrentRequests, int batchOfBytes) {
        Objects.requireNonNull(flushInterval, "flushInterval");
        this.es = Objects.requireNonNull(es, "es");
        this.bulkActions = bulkActions;
        this.batchOfBytes = batchOfBytes;
        this.semaphore = new Semaphore(concurrentRequests > 0 ? concurrentRequests : 1);
        this.requests = new ArrayBlockingQueue(bulkActions + 1);
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(r);
            thread.setName("ElasticSearch BulkProcessor");
            return thread;
        });
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        scheduler.setRemoveOnCancelPolicy(true);
        this.flushInternalInMillis = flushInterval.getSeconds() * 1000L;
        scheduler.scheduleWithFixedDelay((Runnable)new RunnableWithExceptionProtection(this::doPeriodicalFlush, t -> log.error("flush data to ES failure:", t)), 0L, flushInterval.getSeconds(), TimeUnit.SECONDS);
    }

    public CompletableFuture<Void> add(IndexRequest request) {
        return this.internalAdd(request);
    }

    public CompletableFuture<Void> add(UpdateRequest request) {
        return this.internalAdd(request);
    }

    private CompletableFuture<Void> internalAdd(Object request) {
        Objects.requireNonNull(request, "request");
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        this.requests.put(new Holder(f, request));
        this.flushIfNeeded();
        return f;
    }

    private void flushIfNeeded() {
        if (this.requests.size() >= this.bulkActions) {
            this.flush();
        }
    }

    private void doPeriodicalFlush() {
        if (System.currentTimeMillis() - this.lastFlushTS > this.flushInternalInMillis / 2L) {
            this.flush();
        }
    }

    public void flush() {
        if (this.requests.isEmpty()) {
            return;
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            log.error("Interrupted when trying to get semaphore to execute bulk requests", (Throwable)e);
            return;
        }
        ArrayList<Holder> batch = new ArrayList<Holder>(this.requests.size());
        this.requests.drainTo(batch);
        List<CompletableFuture<Void>> futures = this.doFlush(batch);
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        future.whenComplete((v, t) -> this.semaphore.release());
        future.join();
        this.lastFlushTS = System.currentTimeMillis();
    }

    private List<CompletableFuture<Void>> doFlush(List<Holder> batch) {
        log.debug("Executing bulk with {} requests", (Object)batch.size());
        if (batch.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            int bufferOfBytes = 0;
            Codec codec = this.es.get().version().get().codec();
            ArrayList<byte[]> bs = new ArrayList<byte[]>();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            ArrayList<ByteBuf> byteBufList = new ArrayList<ByteBuf>();
            for (Holder holder : batch) {
                byte[] bytes = codec.encode(holder.request);
                bs.add(bytes);
                bs.add("\n".getBytes());
                if ((bufferOfBytes += bytes.length + 1) < this.batchOfBytes) continue;
                ByteBuf content = Unpooled.wrappedBuffer((byte[][])((byte[][])bs.toArray((T[])new byte[0][])));
                byteBufList.add(content);
                bs.clear();
                bufferOfBytes = 0;
            }
            if (CollectionUtils.isNotEmpty(bs)) {
                ByteBuf content = Unpooled.wrappedBuffer((byte[][])((byte[][])bs.toArray((T[])new byte[0][])));
                byteBufList.add(content);
            }
            for (ByteBuf content : byteBufList) {
                CompletionStage future = this.es.get().version().thenCompose(v -> {
                    try {
                        RequestFactory rf = v.requestFactory();
                        return this.es.get().client().execute(rf.bulk().bulk(content)).aggregate().thenAccept(response -> {
                            HttpStatus status = response.status();
                            if (status != HttpStatus.OK) {
                                throw new RuntimeException(response.contentUtf8());
                            }
                        });
                    }
                    catch (Exception e) {
                        return (CompletionStage)Exceptions.throwUnsafely((Throwable)e);
                    }
                });
                ((CompletableFuture)future).whenComplete((ignored, exception) -> {
                    if (exception != null) {
                        batch.stream().map(it -> it.future).forEach(it -> it.completeExceptionally((Throwable)exception));
                        log.error("Failed to execute requests in bulk", exception);
                    } else {
                        log.debug("Succeeded to execute {} requests in bulk", (Object)batch.size());
                        batch.stream().map(it -> it.future).forEach(it -> it.complete(null));
                    }
                });
                futures.add((CompletableFuture<Void>)future);
            }
            return futures;
        }
        catch (Exception e) {
            log.error("Failed to execute requests in bulk", (Throwable)e);
            return Collections.emptyList();
        }
    }

    static class Holder {
        private final CompletableFuture<Void> future;
        private final Object request;

        @Generated
        public Holder(CompletableFuture<Void> future, Object request) {
            this.future = future;
            this.request = request;
        }
    }
}

