/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.circuitbreaker;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.circuitbreaker.AbstractCircuitBreakerClientBuilder;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerClient;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerClientHandler;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerMapping;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRule;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerRuleWithContent;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.UnstableApi;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class CircuitBreakerClientBuilder
extends AbstractCircuitBreakerClientBuilder<HttpRequest, HttpResponse> {
    static final int DEFAULT_MAX_CONTENT_LENGTH = Integer.MAX_VALUE;
    private final boolean needsContentInRule;
    private final int maxContentLength;

    CircuitBreakerClientBuilder(CircuitBreakerRule rule) {
        super(rule);
        this.needsContentInRule = false;
        this.maxContentLength = 0;
    }

    CircuitBreakerClientBuilder(CircuitBreakerRuleWithContent<HttpResponse> ruleWithContent, int maxContentLength) {
        super(ruleWithContent);
        this.needsContentInRule = true;
        this.maxContentLength = maxContentLength;
    }

    public CircuitBreakerClient build(HttpClient delegate) {
        if (this.needsContentInRule) {
            return new CircuitBreakerClient(delegate, this.handler(), this.ruleWithContent(), this.maxContentLength, this.fallback());
        }
        return new CircuitBreakerClient(delegate, this.handler(), this.rule(), this.fallback());
    }

    public Function<? super HttpClient, CircuitBreakerClient> newDecorator() {
        return this::build;
    }

    public CircuitBreakerClientBuilder mapping(CircuitBreakerMapping mapping) {
        return (CircuitBreakerClientBuilder)super.mapping(mapping);
    }

    @UnstableApi
    public CircuitBreakerClientBuilder handler(CircuitBreakerClientHandler handler) {
        return (CircuitBreakerClientBuilder)super.handler(handler);
    }

    public CircuitBreakerClientBuilder recover(BiFunction<? super ClientRequestContext, ? super HttpRequest, ? extends HttpResponse> fallback) {
        return (CircuitBreakerClientBuilder)super.recover(fallback);
    }
}

