/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.mx;

import com.google.protobuf.Any;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Struct;
import com.google.protobuf.TextFormat;
import io.envoyproxy.envoy.data.accesslog.v3.AccessLogCommon;
import io.envoyproxy.envoy.data.accesslog.v3.HTTPAccessLogEntry;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.HTTPServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.v3.HTTPServiceMeshMetrics;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetrics;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.FieldsHelper;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.AbstractALSAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.AccessLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.mx.ServiceMetaInfoAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaExchangeALSHTTPAnalyzer
extends AbstractALSAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaExchangeALSHTTPAnalyzer.class);
    public static final String UPSTREAM_KEY = "wasm.upstream_peer";
    public static final String DOWNSTREAM_KEY = "wasm.downstream_peer";
    public static final String UPSTREAM_PEER = "upstream_peer";
    public static final String DOWNSTREAM_PEER = "downstream_peer";
    protected String fieldMappingFile = "metadata-service-mapping.yaml";
    protected EnvoyMetricReceiverConfig config;

    @Override
    public String name() {
        return "mx-mesh";
    }

    @Override
    public void init(ModuleManager manager, EnvoyMetricReceiverConfig config) throws ModuleStartException {
        this.config = config;
        try {
            FieldsHelper.forClass(config.serviceMetaInfoFactory().clazz()).init(this.fieldMappingFile);
        }
        catch (Exception e) {
            throw new ModuleStartException("Failed to load metadata-service-mapping.yaml", (Throwable)e);
        }
    }

    @Override
    public AccessLogAnalyzer.Result analysis(AccessLogAnalyzer.Result previousResult, StreamAccessLogsMessage.Identifier identifier, HTTPAccessLogEntry entry, Role role) {
        ServiceMetaInfo currSvc;
        if (previousResult.hasUpstreamMetrics() && previousResult.hasDownstreamMetrics()) {
            return previousResult;
        }
        if (!entry.hasCommonProperties()) {
            return previousResult;
        }
        try {
            currSvc = this.adaptToServiceMetaInfo(identifier);
        }
        catch (Exception e) {
            log.error("Failed to inflate the ServiceMetaInfo from identifier.node.metadata. ", (Throwable)e);
            return previousResult;
        }
        AccessLogCommon properties = entry.getCommonProperties();
        Map stateMap = properties.getFilterStateObjectsMap();
        AccessLogAnalyzer.Result.ResultBuilder result = previousResult.toBuilder();
        if (log.isDebugEnabled()) {
            log.debug("Filter state object map: {}", (Object)stateMap);
        }
        if (stateMap.isEmpty()) {
            return result.service(currSvc).build();
        }
        ServiceMeshMetrics.Builder previousMetrics = previousResult.getMetrics();
        HTTPServiceMeshMetrics.Builder httpMetrics = previousMetrics.getHttpMetricsBuilder();
        AtomicBoolean downstreamExists = new AtomicBoolean();
        this.parseFilterObject(previousResult, entry, role, currSvc, stateMap, result, httpMetrics, downstreamExists);
        this.parseFilterObjectPrior124(previousResult, entry, role, currSvc, stateMap, result, httpMetrics, downstreamExists);
        if (role.equals((Object)Role.PROXY) && !downstreamExists.get()) {
            HTTPServiceMeshMetric.Builder metric = this.newAdapter(entry, this.config.serviceMetaInfoFactory().unknown(), currSvc).adaptToDownstreamMetrics();
            if (log.isDebugEnabled()) {
                log.debug("Transformed a {} inbound mesh metric {}", (Object)role, (Object)TextFormat.shortDebugString((MessageOrBuilder)metric));
            }
            httpMetrics.addMetrics(metric);
            result.hasDownstreamMetrics(true);
        }
        return result.metrics(previousMetrics.setHttpMetrics(httpMetrics)).service(currSvc).build();
    }

    @Deprecated(forRemoval=true)
    private void parseFilterObjectPrior124(AccessLogAnalyzer.Result previousResult, HTTPAccessLogEntry entry, Role role, ServiceMetaInfo currSvc, Map<String, Any> stateMap, AccessLogAnalyzer.Result.ResultBuilder result, HTTPServiceMeshMetrics.Builder httpMetrics, AtomicBoolean downstreamExists) {
        stateMap.forEach((key, value) -> {
            ServiceMetaInfo svc;
            if (!key.equals(UPSTREAM_KEY) && !key.equals(DOWNSTREAM_KEY)) {
                return;
            }
            try {
                svc = this.adaptToServiceMetaInfo((Any)value);
            }
            catch (Exception e) {
                log.error("Fail to parse metadata {} to FlatNode", (Object)Base64.getEncoder().encode(value.toByteArray()));
                return;
            }
            switch (key) {
                case "wasm.upstream_peer": {
                    if (previousResult.hasUpstreamMetrics()) break;
                    HTTPServiceMeshMetric.Builder metrics = this.newAdapter(entry, currSvc, svc).adaptToUpstreamMetrics().setTlsMode("NONE");
                    if (log.isDebugEnabled()) {
                        log.debug("Transformed a {} outbound mesh metrics {}", (Object)role, (Object)TextFormat.shortDebugString((MessageOrBuilder)metrics));
                    }
                    httpMetrics.addMetrics(metrics);
                    result.hasUpstreamMetrics(true);
                    break;
                }
                case "wasm.downstream_peer": {
                    if (previousResult.hasDownstreamMetrics()) break;
                    HTTPServiceMeshMetric.Builder metrics = this.newAdapter(entry, svc, currSvc).adaptToDownstreamMetrics();
                    if (log.isDebugEnabled()) {
                        log.debug("Transformed a {} inbound mesh metrics {}", (Object)role, (Object)TextFormat.shortDebugString((MessageOrBuilder)metrics));
                    }
                    httpMetrics.addMetrics(metrics);
                    downstreamExists.set(true);
                    result.hasDownstreamMetrics(true);
                }
            }
        });
    }

    private void parseFilterObject(AccessLogAnalyzer.Result previousResult, HTTPAccessLogEntry entry, Role role, ServiceMetaInfo currSvc, Map<String, Any> stateMap, AccessLogAnalyzer.Result.ResultBuilder result, HTTPServiceMeshMetrics.Builder httpMetrics, AtomicBoolean downstreamExists) {
        stateMap.forEach((key, value) -> {
            ServiceMetaInfo svc;
            if (!key.equals(UPSTREAM_PEER) && !key.equals(DOWNSTREAM_PEER)) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Filter state object key: {}, value: {}", key, value);
            }
            try {
                log.debug("Filter state object value map: {}", (Object)((Struct)value.unpack(Struct.class)).getFieldsMap());
                svc = this.adaptToServiceMetaInfo((Struct)value.unpack(Struct.class));
            }
            catch (Exception e) {
                log.error("Fail to parse metadata {} to FlatNode", (Object)Base64.getEncoder().encode(value.toByteArray()));
                return;
            }
            switch (key) {
                case "upstream_peer": {
                    if (previousResult.hasUpstreamMetrics()) break;
                    HTTPServiceMeshMetric.Builder metrics = this.newAdapter(entry, currSvc, svc).adaptToUpstreamMetrics().setTlsMode("NONE");
                    if (log.isDebugEnabled()) {
                        log.debug("Transformed a {} outbound mesh metrics {}", (Object)role, (Object)TextFormat.shortDebugString((MessageOrBuilder)metrics));
                    }
                    httpMetrics.addMetrics(metrics);
                    result.hasUpstreamMetrics(true);
                    break;
                }
                case "downstream_peer": {
                    if (previousResult.hasDownstreamMetrics()) break;
                    HTTPServiceMeshMetric.Builder metrics = this.newAdapter(entry, svc, currSvc).adaptToDownstreamMetrics();
                    if (log.isDebugEnabled()) {
                        log.debug("Transformed a {} inbound mesh metrics {}", (Object)role, (Object)TextFormat.shortDebugString((MessageOrBuilder)metrics));
                    }
                    httpMetrics.addMetrics(metrics);
                    downstreamExists.set(true);
                    result.hasDownstreamMetrics(true);
                }
            }
        });
    }

    protected ServiceMetaInfo adaptToServiceMetaInfo(Any value) throws Exception {
        return new ServiceMetaInfoAdapter(value);
    }

    protected ServiceMetaInfo adaptToServiceMetaInfo(Struct struct) throws Exception {
        return this.config.serviceMetaInfoFactory().fromStruct(struct);
    }

    protected ServiceMetaInfo adaptToServiceMetaInfo(StreamAccessLogsMessage.Identifier identifier) throws Exception {
        return this.config.serviceMetaInfoFactory().fromStruct(identifier.getNode().getMetadata());
    }
}

