/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener;

import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.browser.source.BrowserAppTrafficCategory;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.browser.provider.BrowserServiceModuleConfig;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.BrowserErrorLogDecorator;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener.ErrorLogAnalysisListener;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener.ErrorLogListenerFactory;
import org.apache.skywalking.oap.server.receiver.browser.provider.parser.errorlog.listener.SourceBuilder;

public class MultiScopesErrorLogAnalysisListener
implements ErrorLogAnalysisListener {
    private final SourceReceiver sourceReceiver;
    private final SourceBuilder sourceBuilder;

    public MultiScopesErrorLogAnalysisListener(SourceReceiver sourceReceiver, NamingControl namingControl) {
        this.sourceReceiver = sourceReceiver;
        this.sourceBuilder = new SourceBuilder(namingControl);
    }

    @Override
    public void build() {
        this.sourceReceiver.receive((ISource)this.sourceBuilder.toBrowserAppTraffic());
        this.sourceReceiver.receive((ISource)this.sourceBuilder.toBrowserAppSingleVersionTraffic());
        this.sourceReceiver.receive((ISource)this.sourceBuilder.toBrowserAppPageTraffic());
    }

    @Override
    public void parse(BrowserErrorLogDecorator decorator) {
        this.sourceBuilder.setService(decorator.getService());
        this.sourceBuilder.setServiceVersion(decorator.getServiceVersion());
        this.sourceBuilder.setPatePath(decorator.getPagePath());
        this.sourceBuilder.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)decorator.getTime()));
        this.sourceBuilder.setTrafficCategory(decorator.isFirstReportedError() ? BrowserAppTrafficCategory.FIRST_ERROR : BrowserAppTrafficCategory.ERROR);
        this.sourceBuilder.setErrorCategory(decorator.getCategory());
    }

    public static class Factory
    implements ErrorLogListenerFactory {
        private final SourceReceiver sourceReceiver;
        private final NamingControl namingControl;

        public Factory(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
            this.namingControl = (NamingControl)moduleManager.find("core").provider().getService(NamingControl.class);
        }

        @Override
        public ErrorLogAnalysisListener create(ModuleManager moduleManager, BrowserServiceModuleConfig moduleConfig) {
            return new MultiScopesErrorLogAnalysisListener(this.sourceReceiver, this.namingControl);
        }
    }
}

