/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.DefaultRequestLog;
import com.linecorp.armeria.common.logging.LogFormatter;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.logging.TextLogFormatterBuilder;
import com.linecorp.armeria.common.util.Functions;
import java.util.Objects;
import java.util.function.BiFunction;

public interface RequestLog
extends RequestOnlyLog {
    public static RequestLogBuilder builder(RequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        return new DefaultRequestLog(ctx);
    }

    public long responseStartTimeMicros();

    public long responseStartTimeMillis();

    public long responseStartTimeNanos();

    @Nullable
    public Long responseFirstBytesTransferredTimeNanos();

    public long responseEndTimeNanos();

    default public long responseDurationNanos() {
        return this.responseEndTimeNanos() - this.responseStartTimeNanos();
    }

    default public long totalDurationNanos() {
        return this.responseEndTimeNanos() - this.requestStartTimeNanos();
    }

    default public HttpStatus responseStatus() {
        return this.responseHeaders().status();
    }

    public long responseLength();

    @Nullable
    public Throwable responseCause();

    public ResponseHeaders responseHeaders();

    @Nullable
    public Object responseContent();

    @Nullable
    public Object rawResponseContent();

    @Nullable
    public String responseContentPreview();

    public HttpHeaders responseTrailers();

    @Deprecated
    default public String toStringResponseOnly() {
        return this.toStringResponseOnly(Functions.second(), Functions.second(), Functions.second());
    }

    @Deprecated
    default public String toStringResponseOnly(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> headersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> contentSanitizer) {
        return this.toStringResponseOnly(headersSanitizer, contentSanitizer, headersSanitizer);
    }

    @Deprecated
    default public String toStringResponseOnly(BiFunction<? super RequestContext, ? super ResponseHeaders, ? extends @Nullable Object> headersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> contentSanitizer, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> trailersSanitizer) {
        return ((TextLogFormatterBuilder)((TextLogFormatterBuilder)((TextLogFormatterBuilder)LogFormatter.builderForText().responseHeadersSanitizer((ctx, headers) -> {
            ResponseHeaders responseHeaders = (ResponseHeaders)headers;
            Object sanitized = headersSanitizer.apply((RequestContext)ctx, responseHeaders);
            if (sanitized == null) {
                return "<sanitized>";
            }
            return sanitized.toString();
        })).responseTrailersSanitizer((ctx, headers) -> {
            Object sanitized = trailersSanitizer.apply((RequestContext)ctx, (HttpHeaders)headers);
            if (sanitized == null) {
                return "<sanitized>";
            }
            return sanitized.toString();
        })).responseContentSanitizer((ctx, content) -> {
            Object sanitized = contentSanitizer.apply((RequestContext)ctx, content);
            if (sanitized == null) {
                return "<sanitized>";
            }
            return sanitized.toString();
        })).includeContext(false).build().formatResponse(this);
    }
}

