/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.analysis.v1alpha1;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum AnalysisMessageBaseLevel {
    UNKNOWN(0),
    ERROR(3),
    WARNING(8),
    INFO(12);

    private final Integer value;
    private static final Map<Integer, AnalysisMessageBaseLevel> CONSTANTS;
    private static final Map<String, AnalysisMessageBaseLevel> NAME_CONSTANTS;

    private AnalysisMessageBaseLevel(Integer value) {
        this.value = value;
    }

    @JsonCreator
    public static AnalysisMessageBaseLevel fromValue(Object value) {
        if (value instanceof String) {
            AnalysisMessageBaseLevel constant = NAME_CONSTANTS.get(((String)value).toLowerCase());
            if (constant == null) {
                throw new IllegalArgumentException(value + "");
            }
            return constant;
        }
        AnalysisMessageBaseLevel constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value + "");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, AnalysisMessageBaseLevel>();
        NAME_CONSTANTS = new HashMap<String, AnalysisMessageBaseLevel>();
        for (AnalysisMessageBaseLevel c : AnalysisMessageBaseLevel.values()) {
            CONSTANTS.put(c.value, c);
        }
        for (AnalysisMessageBaseLevel c : AnalysisMessageBaseLevel.values()) {
            NAME_CONSTANTS.put(c.name().toLowerCase(), c);
        }
    }
}

