/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.spark.MapSizesByExecutorId;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MergeStatus;
import org.apache.spark.scheduler.ShuffleOutputStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleMergedBlockId;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class MapOutputTracker$
implements Logging {
    public static MapOutputTracker$ MODULE$;
    private final String ENDPOINT_NAME;
    private final int DIRECT;
    private final int BROADCAST;
    private final int SHUFFLE_PUSH_MAP_ID;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new MapOutputTracker$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String ENDPOINT_NAME() {
        return this.ENDPOINT_NAME;
    }

    private int DIRECT() {
        return this.DIRECT;
    }

    private int BROADCAST() {
        return this.BROADCAST;
    }

    public int SHUFFLE_PUSH_MAP_ID() {
        return this.SHUFFLE_PUSH_MAP_ID;
    }

    public <T extends ShuffleOutputStatus> Tuple2<byte[], Broadcast<byte[][]>> serializeOutputStatuses(T[] statuses, BroadcastManager broadcastManager, boolean isLocal, int minBroadcastSize, SparkConf conf) {
        ChunkedByteBufferOutputStream out = new ChunkedByteBufferOutputStream(0x100000, (Function1<Object, ByteBuffer>)(Function1 & Serializable & scala.Serializable)x$1 -> MapOutputTracker$.$anonfun$serializeOutputStatuses$1(BoxesRunTime.unboxToInt((Object)x$1)));
        out.write(this.DIRECT());
        CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(conf, conf.get(package$.MODULE$.MAP_STATUS_COMPRESSION_CODEC()));
        ObjectOutputStream objOut = new ObjectOutputStream(codec.compressedOutputStream(out));
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ShuffleOutputStatus[] shuffleOutputStatusArray = statuses;
            synchronized (statuses) {
                objOut.writeObject(statuses);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> objOut.close());
        ChunkedByteBuffer chunkedByteBuf = out.toChunkedByteBuffer();
        long arrSize = out.size();
        if (arrSize >= (long)minBroadcastSize) {
            byte[][] arr = (byte[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chunkedByteBuf.getChunks())).map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.array(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
            Broadcast<byte[][]> bcast = broadcastManager.newBroadcast(arr, isLocal, broadcastManager.newBroadcast$default$3(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            out2.write(this.BROADCAST());
            ObjectOutputStream oos = new ObjectOutputStream(codec.compressedOutputStream((OutputStream)out2));
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> oos.writeObject(bcast), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> oos.close());
            byte[] outArr = out2.toByteArray();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Broadcast outputstatuses size = ").append(outArr.length).append(", actual size = ").append(arrSize).toString());
            return new Tuple2((Object)outArr, bcast);
        }
        return new Tuple2((Object)chunkedByteBuf.toArray(), null);
    }

    public <T extends ShuffleOutputStatus> T[] deserializeOutputStatuses(byte[] bytes, SparkConf conf) {
        Predef$.MODULE$.assert(bytes.length > 0);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes, 1, bytes.length - 1);
        byte by = bytes[0];
        if (this.DIRECT() == by) {
            return (ShuffleOutputStatus[])MapOutputTracker$.deserializeObject$1(in, conf);
        }
        if (this.BROADCAST() == by) {
            ShuffleOutputStatus[] shuffleOutputStatusArray;
            try {
                Broadcast bcast = (Broadcast)MapOutputTracker$.deserializeObject$1(in, conf);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Broadcast outputstatuses size = ").append(bytes.length).append(", actual size = ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bcast.value())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(x$22, x$23) -> BoxesRunTime.boxToLong((long)MapOutputTracker$.$anonfun$deserializeOutputStatuses$4(BoxesRunTime.unboxToLong((Object)x$22), x$23)))).toString());
                ChunkedByteBuffer qual$1 = new ChunkedByteBuffer((ByteBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bcast.value())).map((Function1 & Serializable & scala.Serializable)x$1 -> ByteBuffer.wrap(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ByteBuffer.class))));
                boolean x$12 = qual$1.toInputStream$default$1();
                InputStream bcastIn = qual$1.toInputStream(x$12);
                bcastIn.skip(1L);
                shuffleOutputStatusArray = (ShuffleOutputStatus[])MapOutputTracker$.deserializeObject$1(bcastIn, conf);
            }
            catch (IOException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception encountered during deserializing broadcasted output statuses: ", e);
                throw new SparkException("Unable to deserialize broadcasted output statuses", (Throwable)e);
            }
            return shuffleOutputStatusArray;
        }
        throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected byte tag = ").append(bytes[0]).toString());
    }

    public MapSizesByExecutorId convertMapStatuses(int shuffleId, int startPartition, int endPartition, MapStatus[] mapStatuses, int startMapIndex, int endMapIndex, Option<MergeStatus[]> mergeStatusesOpt) {
        Predef$.MODULE$.assert(mapStatuses != null);
        HashMap splitsByAddress = new HashMap();
        boolean enableBatchFetch = true;
        if (mergeStatusesOpt.exists((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$convertMapStatuses$1(x$24))) && startMapIndex == 0 && endMapIndex == mapStatuses.length) {
            enableBatchFetch = false;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Disable shuffle batch fetch as Push based shuffle is enabled for ").append(shuffleId).append(".").toString());
            MergeStatus[] mergeStatuses = (MergeStatus[])mergeStatusesOpt.get();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startPartition), endPartition).foreach((Function1 & Serializable & scala.Serializable)partId -> MapOutputTracker$.$anonfun$convertMapStatuses$4(mergeStatuses, splitsByAddress, shuffleId, BoxesRunTime.unboxToInt((Object)partId)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapStatuses)).iterator().zipWithIndex().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$convertMapStatuses$6(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$26 -> {
                MapOutputTracker$.$anonfun$convertMapStatuses$7(shuffleId, startPartition, endPartition, mergeStatuses, splitsByAddress, x$26);
                return BoxedUnit.UNIT;
            });
        } else {
            Iterator iter = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapStatuses)).iterator().zipWithIndex();
            iter.slice(startMapIndex, endMapIndex).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$convertMapStatuses$10(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$27 -> {
                MapOutputTracker$.$anonfun$convertMapStatuses$11(shuffleId, startPartition, endPartition, splitsByAddress, x$27);
                return BoxedUnit.UNIT;
            });
        }
        return new MapSizesByExecutorId((Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>>)splitsByAddress.iterator(), enableBatchFetch);
    }

    public Option<MergeStatus[]> convertMapStatuses$default$7() {
        return None$.MODULE$;
    }

    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapStatusesForMergeStatus(int shuffleId, int partitionId, MapStatus[] mapStatuses, RoaringBitmap tracker) {
        Predef$.MODULE$.assert(mapStatuses != null && tracker != null);
        HashMap splitsByAddress = new HashMap();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapStatuses)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$getMapStatusesForMergeStatus$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$28 -> {
            Tuple2 tuple2 = x$28;
            if (tuple2 != null) {
                MapStatus status = (MapStatus)tuple2._1();
                int mapIndex = tuple2._2$mcI$sp();
                if (tracker.contains(mapIndex)) {
                    MODULE$.validateStatus(status, shuffleId, partitionId);
                    return ((ListBuffer)splitsByAddress.getOrElseUpdate((Object)status.location(), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)new Tuple3((Object)new ShuffleBlockId(shuffleId, status.mapId(), partitionId), (Object)BoxesRunTime.boxToLong((long)status.getSizeForBlock(partitionId)), (Object)BoxesRunTime.boxToInteger((int)mapIndex)));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        return splitsByAddress.iterator();
    }

    public void validateStatus(ShuffleOutputStatus status, int shuffleId, int partition) {
        if (status == null) {
            String errorMessage = new StringBuilder(50).append("Missing an output location for shuffle ").append(shuffleId).append(" partition ").append(partition).toString();
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
            throw new MetadataFetchFailedException(shuffleId, partition, errorMessage);
        }
    }

    public static final /* synthetic */ ByteBuffer $anonfun$serializeOutputStatuses$1(int x$1) {
        return ByteBuffer.allocate(x$1);
    }

    private static final Object deserializeObject$1(InputStream in, SparkConf conf$4) {
        CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(conf$4, conf$4.get(package$.MODULE$.MAP_STATUS_COMPRESSION_CODEC()));
        ObjectInputStream objIn = new ObjectInputStream(codec.compressedInputStream(in));
        return Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> objIn.readObject(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> objIn.close());
    }

    public static final /* synthetic */ long $anonfun$deserializeOutputStatuses$4(long x$22, byte[] x$23) {
        return x$22 + (long)x$23.length;
    }

    public static final /* synthetic */ boolean $anonfun$convertMapStatuses$2(MergeStatus x$25) {
        return x$25 != null;
    }

    public static final /* synthetic */ boolean $anonfun$convertMapStatuses$1(MergeStatus[] x$24) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$24)).exists((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$convertMapStatuses$2(x$25)));
    }

    public static final /* synthetic */ Object $anonfun$convertMapStatuses$4(MergeStatus[] mergeStatuses$1, HashMap splitsByAddress$1, int shuffleId$12, int partId) {
        MergeStatus mergeStatus = mergeStatuses$1[partId];
        if (mergeStatus != null && mergeStatus.totalSize() > 0L) {
            return ((ListBuffer)splitsByAddress$1.getOrElseUpdate((Object)mergeStatus.location(), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)new Tuple3((Object)new ShuffleMergedBlockId(shuffleId$12, mergeStatus.shuffleMergeId(), partId), (Object)BoxesRunTime.boxToLong((long)mergeStatus.totalSize()), (Object)BoxesRunTime.boxToInteger((int)MODULE$.SHUFFLE_PUSH_MAP_ID())));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$convertMapStatuses$6(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ Object $anonfun$convertMapStatuses$8(MergeStatus[] mergeStatuses$1, int mapIndex$3, MapStatus mapStatus$2, HashMap splitsByAddress$1, int shuffleId$12, int partId) {
        MergeStatus mergeStatus = mergeStatuses$1[partId];
        if (mergeStatus == null || mergeStatus.totalSize() == 0L || !mergeStatus.tracker().contains(mapIndex$3)) {
            long size = mapStatus$2.getSizeForBlock(partId);
            if (size != 0L) {
                return ((ListBuffer)splitsByAddress$1.getOrElseUpdate((Object)mapStatus$2.location(), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)new Tuple3((Object)new ShuffleBlockId(shuffleId$12, mapStatus$2.mapId(), partId), (Object)BoxesRunTime.boxToLong((long)size), (Object)BoxesRunTime.boxToInteger((int)mapIndex$3)));
            }
            return BoxedUnit.UNIT;
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$convertMapStatuses$7(int shuffleId$12, int startPartition$3, int endPartition$3, MergeStatus[] mergeStatuses$1, HashMap splitsByAddress$1, Tuple2 x$26) {
        Tuple2 tuple2 = x$26;
        if (tuple2 != null) {
            MapStatus mapStatus = (MapStatus)tuple2._1();
            int mapIndex = tuple2._2$mcI$sp();
            MODULE$.validateStatus(mapStatus, shuffleId$12, startPartition$3);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startPartition$3), endPartition$3).foreach((Function1 & Serializable & scala.Serializable)partId -> MapOutputTracker$.$anonfun$convertMapStatuses$8(mergeStatuses$1, mapIndex, mapStatus, splitsByAddress$1, shuffleId$12, BoxesRunTime.unboxToInt((Object)partId)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$convertMapStatuses$10(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ Object $anonfun$convertMapStatuses$12(MapStatus status$3, HashMap splitsByAddress$1, int shuffleId$12, int mapIndex$4, int part) {
        long size = status$3.getSizeForBlock(part);
        if (size != 0L) {
            return ((ListBuffer)splitsByAddress$1.getOrElseUpdate((Object)status$3.location(), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)new Tuple3((Object)new ShuffleBlockId(shuffleId$12, status$3.mapId(), part), (Object)BoxesRunTime.boxToLong((long)size), (Object)BoxesRunTime.boxToInteger((int)mapIndex$4)));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$convertMapStatuses$11(int shuffleId$12, int startPartition$3, int endPartition$3, HashMap splitsByAddress$1, Tuple2 x$27) {
        Tuple2 tuple2 = x$27;
        if (tuple2 != null) {
            MapStatus status = (MapStatus)tuple2._1();
            int mapIndex = tuple2._2$mcI$sp();
            MODULE$.validateStatus(status, shuffleId$12, startPartition$3);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startPartition$3), endPartition$3).foreach((Function1 & Serializable & scala.Serializable)part -> MapOutputTracker$.$anonfun$convertMapStatuses$12(status, splitsByAddress$1, shuffleId$12, mapIndex, BoxesRunTime.unboxToInt((Object)part)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getMapStatusesForMergeStatus$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        return tuple2 != null;
    }

    private MapOutputTracker$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.ENDPOINT_NAME = "MapOutputTracker";
        this.DIRECT = 0;
        this.BROADCAST = 1;
        this.SHUFFLE_PUSH_MAP_ID = -1;
    }
}

