/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.QueryContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.connector.util.V2ExpressionSQLBuilder;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProvider$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0011-g!B!C\u0003\u0003i\u0005\"B/\u0001\t\u0003q\u0006\"B1\u0001\r\u0003\u0011\u0007\"B:\u0001\t\u0003!\bbBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!!\u001a\u0001\t\u0003\t9\u0007C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0006bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003\u001f\u0004A\u0011AAi\u0011\u001d\tY\u000e\u0001C\u0001\u0003;Dq!a7\u0001\t\u0003\t9\u000fC\u0005\u0002x\u0002\t\n\u0011\"\u0001\u0002z\"9!Q\u0002\u0001\u0005\u0002\t=\u0001\u0002\u0003B\u0010\u0001\u0011E!I!\t\t\u000f\t%\u0002\u0001\"\u0001\u0003,\u00199!q\u0007\u0001\u0001\u0005\ne\u0002BB/\u0014\t\u0003\u0011Y\u0005C\u0004\u0003RM!\tBa\u0015\t\u000f\t\u00154\u0003\"\u0005\u0003h!9!1N\n\u0005B\t5\u0004b\u0002BF'\u0011\u0005#Q\u0012\u0005\b\u00053\u001bB\u0011\tBN\u0011\u001d\u0011)k\u0005C!\u0005OCqAa.\u0014\t\u0003\u0012I\fC\u0004\u0003DN!\tB!2\t\u000f\t%7\u0003\"\u0011\u0003L\"9!qZ\n\u0005B\tE\u0007B\u0004Bm'A\u0005\u0019\u0011!A\u0005\n\tm'Q\u001f\u0005\b\u0005o\u0004A\u0011\u0001B}\u0011\u001d\u0011y\u0010\u0001C\u0001\u0007\u0003Aqaa\u0003\u0001\t\u0003\u0019i\u0001C\u0004\u00042\u0001!\taa\r\t\u000f\rm\u0003\u0001\"\u0001\u0004^!91\u0011\u000e\u0001\u0005\u0002\r-\u0004bBB;\u0001\u0011\u00051q\u000f\u0005\b\u0007\u007f\u0002A\u0011ABA\u0011\u001d\u0019\u0019\t\u0001C\u0001\u0007\u000bCqaa!\u0001\t\u0003\u0019)\nC\u0004\u0004&\u0002!\taa*\t\u000f\rm\u0006\u0001\"\u0001\u0004>\"91q\u0019\u0001\u0005\u0002\r%\u0007bBBk\u0001\u0011\u00051q\u001b\u0005\b\u0007;\u0004A\u0011ABp\u0011\u001d\u0019I\u000f\u0001C\u0001\u0007WDqa!>\u0001\t\u0003\u00199\u0010C\u0004\u0004~\u0002!\taa@\t\u000f\u0011\u0015\u0001\u0001\"\u0001\u0005\b!9A1\u0002\u0001\u0005\u0002\u00115\u0001b\u0002C\n\u0001\u0011\u0005AQ\u0003\u0005\b\tk\u0001A\u0011\u0001C\u001c\u0011\u001d!\t\u0005\u0001C\u0001\t\u0007Bq\u0001\"\u0013\u0001\t\u0003!Y\u0005C\u0004\u0005b\u0001!\t\u0001b\u0019\t\u000f\u0011m\u0004\u0001\"\u0001\u0005~!9A\u0011\u0012\u0001\u0005\u0002\u0011-\u0005b\u0002CI\u0001\u0011\u0005A1\u0013\u0005\b\t;\u0003A\u0011\u0001CP\u0011\u001d!\t\u000b\u0001C\u0001\t?Cq\u0001b)\u0001\t\u0003!y\nC\u0004\u0005&\u0002!\t\u0001b*\t\u000f\u0011e\u0006\u0001\"\u0001\u0005<\nY!\n\u001a2d\t&\fG.Z2u\u0015\t\u0019E)\u0001\u0003kI\n\u001c'BA#G\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f\"\u000bQa\u001d9be.T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011\u0003\u0002\u0001O)^\u0003\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a!\u00118z%\u00164\u0007CA(V\u0013\t1\u0006K\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002Y76\t\u0011L\u0003\u0002[\r\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002]3\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001`!\t\u0001\u0007!D\u0001C\u0003%\u0019\u0017M\u001c%b]\u0012dW\r\u0006\u0002dMB\u0011q\nZ\u0005\u0003KB\u0013qAQ8pY\u0016\fg\u000eC\u0003h\u0005\u0001\u0007\u0001.A\u0002ve2\u0004\"!\u001b9\u000f\u0005)t\u0007CA6Q\u001b\u0005a'BA7M\u0003\u0019a$o\\8u}%\u0011q\u000eU\u0001\u0007!J,G-\u001a4\n\u0005E\u0014(AB*ue&twM\u0003\u0002p!\u0006yq-\u001a;DCR\fG._:u)f\u0004X\r\u0006\u0005v}\u0006\u001d\u00111BA\b!\rye\u000f_\u0005\u0003oB\u0013aa\u00149uS>t\u0007CA=}\u001b\u0005Q(BA>E\u0003\u0015!\u0018\u0010]3t\u0013\ti(P\u0001\u0005ECR\fG+\u001f9f\u0011\u0019y8\u00011\u0001\u0002\u0002\u000591/\u001d7UsB,\u0007cA(\u0002\u0004%\u0019\u0011Q\u0001)\u0003\u0007%sG\u000f\u0003\u0004\u0002\n\r\u0001\r\u0001[\u0001\tif\u0004XMT1nK\"9\u0011QB\u0002A\u0002\u0005\u0005\u0011\u0001B:ju\u0016Dq!!\u0005\u0004\u0001\u0004\t\u0019\"\u0001\u0002nIB\u0019\u00110!\u0006\n\u0007\u0005]!PA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u0003-9W\r\u001e&E\u0005\u000e#\u0016\u0010]3\u0015\t\u0005u\u0011Q\u0005\t\u0005\u001fZ\fy\u0002E\u0002a\u0003CI1!a\tC\u0005!QEMY2UsB,\u0007BBA\u0014\t\u0001\u0007\u00010\u0001\u0002ei\u0006y2m\u001c8wKJ$(*\u0019<b)&lWm\u001d;b[B$v\u000eV5nKN$\u0018-\u001c9\u0015\t\u00055\u00121\b\t\u0005\u0003_\t9$\u0004\u0002\u00022)\u0019Q)a\r\u000b\u0005\u0005U\u0012\u0001\u00026bm\u0006LA!!\u000f\u00022\tIA+[7fgR\fW\u000e\u001d\u0005\b\u0003{)\u0001\u0019AA\u0017\u0003\u0005!\b&B\u0003\u0002B\u00055\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dc)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0013\u0002F\t)1+\u001b8dK\u0006\u0012\u0011qJ\u0001\u0006g9*d\u0006M\u0001#G>tg/\u001a:u\u0015\u00064\u0018\rV5nKN$\u0018-\u001c9U_RKW.Z:uC6\u0004h\n\u0016.\u0015\t\u0005U\u0013\u0011\r\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)!\u00111LA\u001a\u0003\u0011!\u0018.\\3\n\t\u0005}\u0013\u0011\f\u0002\u000e\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\t\u000f\u0005ub\u00011\u0001\u0002.!*a!!\u0011\u0002N\u0005\u00113m\u001c8wKJ$H+[7fgR\fW\u000e\u001d(U5R{'*\u0019<b)&lWm\u001d;b[B$B!!\f\u0002j!9\u00111N\u0004A\u0002\u0005U\u0013a\u00017ei\"*q!!\u0011\u0002N\u000592M]3bi\u0016\u001cuN\u001c8fGRLwN\u001c$bGR|'/\u001f\u000b\u0005\u0003g\ny\bE\u0004P\u0003k\n\t!!\u001f\n\u0007\u0005]\u0004KA\u0005Gk:\u001cG/[8ocA!\u0011qFA>\u0013\u0011\ti(!\r\u0003\u0015\r{gN\\3di&|g\u000eC\u0004\u0002\u0002\"\u0001\r!a!\u0002\u000f=\u0004H/[8ogB!\u0011QQAI\u001b\t\t9IC\u0002D\u0003\u0013SA!a#\u0002\u000e\u0006YA-\u0019;bg>,(oY3t\u0015\r\ty\tR\u0001\nKb,7-\u001e;j_:LA!a%\u0002\b\nY!\n\u0012\"D\u001fB$\u0018n\u001c8tQ\u0015A\u0011\u0011IALC\t\tI*A\u00034]Mr\u0003'A\brk>$X-\u00133f]RLg-[3s)\rA\u0017q\u0014\u0005\u0007\u0003CK\u0001\u0019\u00015\u0002\u000f\r|GNT1nK\u0006Y1M]3bi\u0016$\u0016M\u00197f))\t9+!,\u00028\u0006m\u0016q\u0018\t\u0004\u001f\u0006%\u0016bAAV!\n!QK\\5u\u0011\u001d\tyK\u0003a\u0001\u0003c\u000b\u0011b\u001d;bi\u0016lWM\u001c;\u0011\t\u0005=\u00121W\u0005\u0005\u0003k\u000b\tDA\u0005Ti\u0006$X-\\3oi\"1\u0011\u0011\u0018\u0006A\u0002!\f\u0011\u0002^1cY\u0016t\u0015-\\3\t\r\u0005u&\u00021\u0001i\u0003%\u0019HO]*dQ\u0016l\u0017\rC\u0004\u0002\u0002*\u0001\r!!1\u0011\t\u0005\u0015\u00151Y\u0005\u0005\u0003\u000b\f9I\u0001\nKI\n\u001cw\n\u001d;j_:\u001c\u0018J\\,sSR,\u0017aE4fiR\u000b'\r\\3Fq&\u001cHo])vKJLHc\u00015\u0002L\"1\u0011QZ\u0006A\u0002!\fQ\u0001^1cY\u0016\fabZ3u'\u000eDW-\\1Rk\u0016\u0014\u0018\u0010F\u0002i\u0003'Da!!4\r\u0001\u0004A\u0007&\u0002\u0007\u0002B\u0005]\u0017EAAm\u0003\u0015\u0011d&\r\u00181\u0003A9W\r\u001e+sk:\u001c\u0017\r^3Rk\u0016\u0014\u0018\u0010F\u0002i\u0003?Da!!4\u000e\u0001\u0004A\u0007&B\u0007\u0002B\u0005\r\u0018EAAs\u0003\u0015\u0011df\r\u00181)\u0015A\u0017\u0011^Av\u0011\u0019\tiM\u0004a\u0001Q\"I\u0011Q\u001e\b\u0011\u0002\u0003\u0007\u0011q^\u0001\bG\u0006\u001c8-\u00193f!\ryeo\u0019\u0015\u0006\u001d\u0005\u0005\u00131_\u0011\u0003\u0003k\fQA\r\u00185]A\n!dZ3u)J,hnY1uKF+XM]=%I\u00164\u0017-\u001e7uII*\"!a?+\t\u0005=\u0018Q`\u0016\u0003\u0003\u007f\u0004BA!\u0001\u0003\n5\u0011!1\u0001\u0006\u0005\u0005\u000b\u00119!A\u0005v]\u000eDWmY6fI*\u0019\u0011q\t)\n\t\t-!1\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00032fM>\u0014XMR3uG\"$b!a*\u0003\u0012\tU\u0001b\u0002B\n!\u0001\u0007\u0011\u0011P\u0001\u000bG>tg.Z2uS>t\u0007b\u0002B\f!\u0001\u0007!\u0011D\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\b#B5\u0003\u001c!D\u0017b\u0001B\u000fe\n\u0019Q*\u00199\u0002\u0013\u0015\u001c8-\u00199f'FdGc\u00015\u0003$!1!QE\tA\u0002!\fQA^1mk\u0016DS!EA!\u0003G\fAbY8na&dWMV1mk\u0016$BA!\f\u00034A\u0019qJa\f\n\u0007\tE\u0002KA\u0002B]fDqA!\n\u0013\u0001\u0004\u0011i\u0003K\u0003\u0013\u0003\u0003\n\u0019O\u0001\bK\t\n\u001b5+\u0015'Ck&dG-\u001a:\u0014\u0007M\u0011Y\u0004\u0005\u0003\u0003>\t\u001dSB\u0001B \u0015\u0011\u0011\tEa\u0011\u0002\tU$\u0018\u000e\u001c\u0006\u0004\u0005\u000b\"\u0015!C2p]:,7\r^8s\u0013\u0011\u0011IEa\u0010\u0003-Y\u0013T\t\u001f9sKN\u001c\u0018n\u001c8T#2\u0013U/\u001b7eKJ$\"A!\u0014\u0011\u0007\t=3#D\u0001\u0001\u0003AIg\u000e];u)>\u001c\u0016\u000b\u0014(p\u0005>|G\u000eF\u0002i\u0005+BqAa\u0016\u0016\u0001\u0004\u0011I&A\u0003j]B,H\u000f\u0005\u0003\u0003\\\t\u0005TB\u0001B/\u0015\u0011\u0011yFa\u0011\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0005G\u0012iF\u0001\u0006FqB\u0014Xm]:j_:\f\u0011\u0003\u001d:fI&\u001c\u0017\r^3U_&sGoU)M)\rA'\u0011\u000e\u0005\u0007\u0005/2\u0002\u0019\u00015\u0002\u0019YL7/\u001b;MSR,'/\u00197\u0015\u0007!\u0014y\u0007C\u0004\u0003r]\u0001\rAa\u001d\u0002\u000f1LG/\u001a:bYB\"!Q\u000fB@!\u0019\u0011YFa\u001e\u0003|%!!\u0011\u0010B/\u0005\u001da\u0015\u000e^3sC2\u0004BA! \u0003\u00001\u0001A\u0001\u0004BA\u0005_\n\t\u0011!A\u0003\u0002\t\r%aA0%cE!!Q\u0011B\u0017!\ry%qQ\u0005\u0004\u0005\u0013\u0003&a\u0002(pi\"LgnZ\u0001\u0014m&\u001c\u0018\u000e\u001e(b[\u0016$'+\u001a4fe\u0016t7-\u001a\u000b\u0004Q\n=\u0005b\u0002BI1\u0001\u0007!1S\u0001\t]\u0006lW\r\u001a*fMB!!1\fBK\u0013\u0011\u00119J!\u0018\u0003\u001d9\u000bW.\u001a3SK\u001a,'/\u001a8dK\u0006Ia/[:ji\u000e\u000b7\u000f\u001e\u000b\u0006Q\nu%\u0011\u0015\u0005\u0007\u0005?K\u0002\u0019\u00015\u0002\u00031DaAa)\u001a\u0001\u0004A\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0002!YL7/\u001b;T#23UO\\2uS>tG#\u00025\u0003*\n5\u0006B\u0002BV5\u0001\u0007\u0001.\u0001\u0005gk:\u001cg*Y7f\u0011\u001d\u0011yK\u0007a\u0001\u0005c\u000ba!\u001b8qkR\u001c\b\u0003B(\u00034\"L1A!.Q\u0005\u0015\t%O]1z\u0003Y1\u0018n]5u\u0003\u001e<'/Z4bi\u00164UO\\2uS>tGc\u00025\u0003<\nu&\u0011\u0019\u0005\u0007\u0005W[\u0002\u0019\u00015\t\r\t}6\u00041\u0001d\u0003)I7\u000fR5ti&t7\r\u001e\u0005\b\u0005_[\u0002\u0019\u0001BY\u0003M!\u0017.\u00197fGR4UO\\2uS>tg*Y7f)\rA'q\u0019\u0005\u0007\u0005Wc\u0002\u0019\u00015\u0002\u0019YL7/\u001b;Pm\u0016\u0014H.Y=\u0015\u0007!\u0014i\rC\u0004\u00030v\u0001\rA!-\u0002\u0013YL7/\u001b;Ue&lG#\u00025\u0003T\n]\u0007B\u0002Bk=\u0001\u0007\u0001.A\u0005eSJ,7\r^5p]\"9!q\u0016\u0010A\u0002\tE\u0016AE:va\u0016\u0014HE^5tSRd\u0015\u000e^3sC2$BA!8\u0003hB!!q\u001cBs\u001b\t\u0011\tO\u0003\u0003\u0003d\u0006M\u0012\u0001\u00027b]\u001eL1!\u001dBq\u0011%\u0011IoHA\u0001\u0002\u0004\u0011Y/A\u0002yIE\u0002DA!<\u0003rB1!1\fB<\u0005_\u0004BA! \u0003r\u0012a!1\u001fBt\u0003\u0003\u0005\tQ!\u0001\u0003\u0004\n\u0011q\bM\u0005\u0005\u0005W\u00129%A\njgN+\b\u000f]8si\u0016$g)\u001e8di&|g\u000eF\u0002d\u0005wDaAa+!\u0001\u0004A\u0007&\u0002\u0011\u0002B\u0005]\u0015!E2p[BLG.Z#yaJ,7o]5p]R!11AB\u0003!\rye\u000f\u001b\u0005\b\u0007\u000f\t\u0003\u0019\u0001B-\u0003\u0011)\u0007\u0010\u001d:)\u000b\u0005\n\t%a&\u0002!\r|W\u000e]5mK\u0006;wM]3hCR,G\u0003BB\u0002\u0007\u001fAqa!\u0005#\u0001\u0004\u0019\u0019\"A\u0006bO\u001e4UO\\2uS>t\u0007\u0003BB\u000b\u00077i!aa\u0006\u000b\t\re!QL\u0001\nC\u001e<'/Z4bi\u0016LAa!\b\u0004\u0018\ti\u0011iZ4sK\u001e\fG/\u001a$v]\u000eDsAIB\u0011\u0007O\u0019Y\u0003E\u0002P\u0007GI1a!\nQ\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0007S\tA)^:fA=\u0014xML1qC\u000eDWML:qCJ\\gf]9m])$'m\u0019\u0018KI\n\u001cG)[1mK\u000e$hfY8na&dW-\u0012=qe\u0016\u001c8/[8oA%t7\u000f^3bI:\n#a!\f\u0002\u000bMrCG\f\u0019)\u000b\t\n\t%a&\u0002\u0013\u0019,hn\u0019;j_:\u001cXCAB\u001b!\u0019\u00199d!\u0011\u0004H9!1\u0011HB\u001f\u001d\rY71H\u0005\u0002#&\u00191q\b)\u0002\u000fA\f7m[1hK&!11IB#\u0005\r\u0019V-\u001d\u0006\u0004\u0007\u007f\u0001\u0006CB(\u0004J!\u001ci%C\u0002\u0004LA\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BB(\u0007/j!a!\u0015\u000b\t\rE21\u000b\u0006\u0005\u0007+\u0012\u0019%A\u0004dCR\fGn\\4\n\t\re3\u0011\u000b\u0002\u0010+:\u0014w.\u001e8e\rVt7\r^5p]\u0006a1M]3bi\u0016\u001c6\r[3nCRA\u0011qUB0\u0007C\u001a)\u0007C\u0004\u00020\u0012\u0002\r!!-\t\r\r\rD\u00051\u0001i\u0003\u0019\u00198\r[3nC\"11q\r\u0013A\u0002!\fqaY8n[\u0016tG/A\u0007tG\",W.Y:Fq&\u001cHo\u001d\u000b\bG\u000e54\u0011OB:\u0011\u001d\u0019y'\na\u0001\u0003s\nAaY8o]\"9\u0011\u0011Q\u0013A\u0002\u0005\r\u0005BBB2K\u0001\u0007\u0001.A\u0006mSN$8k\u00195f[\u0006\u001cHCBB=\u0007w\u001ai\bE\u0003P\u0005g\u0013\t\fC\u0004\u0004p\u0019\u0002\r!!\u001f\t\u000f\u0005\u0005e\u00051\u0001\u0002\u0004\u0006A\u0012n]\"bg\u000e\fG-\u001b8h)J,hnY1uKR\u000b'\r\\3\u0015\u0005\u0005=\u0018a\u0003:f]\u0006lW\rV1cY\u0016$R\u0001[BD\u0007\u0017Caa!#)\u0001\u0004A\u0017\u0001C8mIR\u000b'\r\\3\t\r\r5\u0005\u00061\u0001i\u0003!qWm\u001e+bE2,\u0007f\u0002\u0015\u0004\"\rE\u0015QJ\u0011\u0003\u0007'\u000b1\u0007\u00157fCN,\u0007e\u001c<feJLG-\u001a\u0011sK:\fW.\u001a+bE2,\u0007%\\3uQ>$\u0007e^5uQ\u0002JG-\u001a8uS\u001aLWM]:\u0015\u000b!\u001c9j!)\t\u000f\r%\u0015\u00061\u0001\u0004\u001aB!11TBO\u001b\t\u0019\u0019&\u0003\u0003\u0004 \u000eM#AC%eK:$\u0018NZ5fe\"91QR\u0015A\u0002\re\u0005&B\u0015\u0002B\u00055\u0013AC1mi\u0016\u0014H+\u00192mKRA!\u0011WBU\u0007W\u001b9\f\u0003\u0004\u0002:*\u0002\r\u0001\u001b\u0005\b\u0007[S\u0003\u0019ABX\u0003\u001d\u0019\u0007.\u00198hKN\u0004baa\u000e\u0004B\rE\u0006\u0003BBN\u0007gKAa!.\u0004T\tYA+\u00192mK\u000eC\u0017M\\4f\u0011\u001d\u0019IL\u000ba\u0001\u0003\u0003\ta\u0002\u001a2NC*|'OV3sg&|g.A\thKR\fE\rZ\"pYVlg.U;fef$r\u0001[B`\u0007\u0003\u001c)\r\u0003\u0004\u0002:.\u0002\r\u0001\u001b\u0005\u0007\u0007\u0007\\\u0003\u0019\u00015\u0002\u0015\r|G.^7o\u001d\u0006lW\r\u0003\u0004\u0003$.\u0002\r\u0001[\u0001\u0015O\u0016$(+\u001a8b[\u0016\u001cu\u000e\\;n]F+XM]=\u0015\u0013!\u001cYm!4\u0004P\u000eM\u0007BBA]Y\u0001\u0007\u0001\u000e\u0003\u0004\u0004D2\u0002\r\u0001\u001b\u0005\u0007\u0007#d\u0003\u0019\u00015\u0002\u000f9,wOT1nK\"91\u0011\u0018\u0017A\u0002\u0005\u0005\u0011\u0001F4fi\u0012+G.\u001a;f\u0007>dW/\u001c8Rk\u0016\u0014\u0018\u0010F\u0003i\u00073\u001cY\u000e\u0003\u0004\u0002:6\u0002\r\u0001\u001b\u0005\u0007\u0007\u0007l\u0003\u0019\u00015\u00021\u001d,G/\u00169eCR,7i\u001c7v[:$\u0016\u0010]3Rk\u0016\u0014\u0018\u0010F\u0004i\u0007C\u001c\u0019o!:\t\r\u0005ef\u00061\u0001i\u0011\u0019\u0019\u0019M\fa\u0001Q\"11q\u001d\u0018A\u0002!\f1B\\3x\t\u0006$\u0018\rV=qK\u0006yr-\u001a;Va\u0012\fG/Z\"pYVlgNT;mY\u0006\u0014\u0017\u000e\\5usF+XM]=\u0015\u000f!\u001cioa<\u0004r\"1\u0011\u0011X\u0018A\u0002!Daaa10\u0001\u0004A\u0007BBBz_\u0001\u00071-\u0001\u0006jg:+H\u000e\\1cY\u0016\fAcZ3u)\u0006\u0014G.Z\"p[6,g\u000e^)vKJLH#\u00025\u0004z\u000em\bBBAga\u0001\u0007\u0001\u000e\u0003\u0004\u0004hA\u0002\r\u0001[\u0001\u0016O\u0016$8k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\u0015AG\u0011\u0001C\u0002\u0011\u0019\u0019\u0019'\ra\u0001Q\"11qM\u0019A\u0002!\f\u0001D]3n_Z,7k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\rAG\u0011\u0002\u0005\u0007\u0007G\u0012\u0004\u0019\u00015\u0002\u0015\u0011\u0014x\u000e]*dQ\u0016l\u0017\rF\u0003i\t\u001f!\t\u0002\u0003\u0004\u0004dM\u0002\r\u0001\u001b\u0005\u0007\u0003[\u001c\u0004\u0019A2\u0002\u0017\r\u0014X-\u0019;f\u0013:$W\r\u001f\u000b\fQ\u0012]A1\u0004C\u0010\tK!\u0019\u0004\u0003\u0004\u0005\u001aQ\u0002\r\u0001[\u0001\nS:$W\r\u001f(b[\u0016Dq\u0001\"\b5\u0001\u0004\u0019I*\u0001\u0006uC\ndW-\u00133f]RDq\u0001\"\t5\u0001\u0004!\u0019#A\u0004d_2,XN\\:\u0011\u000b=\u0013\u0019La%\t\u000f\u0011\u001dB\u00071\u0001\u0005*\u0005\t2m\u001c7v[:\u001c\bK]8qKJ$\u0018.Z:\u0011\u0011\u0011-Bq\u0006BJ\tci!\u0001\"\f\u000b\t\t\u0005\u00131G\u0005\u0005\u0005;!i\u0003\u0005\u0004\u0005,\u0011=\u0002\u000e\u001b\u0005\b\u0005/!\u0004\u0019\u0001C\u0019\u0003-Ig\u000eZ3y\u000bbL7\u000f^:\u0015\u0013\r$I\u0004b\u000f\u0005>\u0011}\u0002bBB8k\u0001\u0007\u0011\u0011\u0010\u0005\u0007\t3)\u0004\u0019\u00015\t\u000f\u0011uQ\u00071\u0001\u0004\u001a\"9\u0011\u0011Q\u001bA\u0002\u0005\r\u0015!\u00033s_BLe\u000eZ3y)\u0015AGQ\tC$\u0011\u0019!IB\u000ea\u0001Q\"9AQ\u0004\u001cA\u0002\re\u0015a\u00037jgRLe\u000eZ3yKN$\u0002\u0002\"\u0014\u0005\\\u0011uCq\f\t\u0006\u001f\nMFq\n\t\u0005\t#\"9&\u0004\u0002\u0005T)!AQKB*\u0003\u0015Ig\u000eZ3y\u0013\u0011!I\u0006b\u0015\u0003\u0015Q\u000b'\r\\3J]\u0012,\u0007\u0010C\u0004\u0004p]\u0002\r!!\u001f\t\u000f\u0011uq\u00071\u0001\u0004\u001a\"9\u0011\u0011Q\u001cA\u0002\u0005\r\u0015!E2mCN\u001c\u0018NZ=Fq\u000e,\u0007\u000f^5p]R1AQ\rC7\tc\u0002B\u0001b\u001a\u0005j5\tA)C\u0002\u0005l\u0011\u0013\u0011#\u00118bYf\u001c\u0018n]#yG\u0016\u0004H/[8o\u0011\u0019!y\u0007\u000fa\u0001Q\u00069Q.Z:tC\u001e,\u0007b\u0002C:q\u0001\u0007AQO\u0001\u0002KB!1q\u0007C<\u0013\u0011!Ih!\u0012\u0003\u0013QC'o\\<bE2,\u0017AD4fi2KW.\u001b;DY\u0006,8/\u001a\u000b\u0004Q\u0012}\u0004b\u0002CAs\u0001\u0007A1Q\u0001\u0006Y&l\u0017\u000e\u001e\t\u0005\u0005?$))\u0003\u0003\u0005\b\n\u0005(aB%oi\u0016<WM]\u0001\u0010O\u0016$xJ\u001a4tKR\u001cE.Y;tKR\u0019\u0001\u000e\"$\t\u000f\u0011=%\b1\u0001\u0005\u0004\u00061qN\u001a4tKR\facZ3u\u0015\u0012\u00147mU)M#V,'/\u001f\"vS2$WM\u001d\u000b\u0005\t+#Y\nE\u0002a\t/K1\u0001\"'C\u0005MQEMY2T#2\u000bV/\u001a:z\u0005VLG\u000eZ3s\u0011\u001d\t\ti\u000fa\u0001\u0003\u0007\u000bQb];qa>\u0014Ho\u001d'j[&$X#A2\u0002\u001dM,\b\u000f]8siN|eMZ:fi\u0006\u00192/\u001e9q_J$8\u000fV1cY\u0016\u001c\u0016-\u001c9mK\u0006qq-\u001a;UC\ndWmU1na2,Gc\u00015\u0005*\"9A1V A\u0002\u00115\u0016AB:b[BdW\r\u0005\u0003\u00050\u0012UVB\u0001CY\u0015\u0011!\u0019,!#\u0002\u0005Y\u0014\u0014\u0002\u0002C\\\tc\u0013q\u0002V1cY\u0016\u001c\u0016-\u001c9mK&sgm\\\u0001!O\u0016$h)\u001e7msF+\u0018\r\\5gS\u0016$\u0017+^8uK\u0012$\u0016M\u00197f\u001d\u0006lW\rF\u0002i\t{Cq\u0001b0A\u0001\u0004\u0019I*A\u0003jI\u0016tG\u000fK\u0003A\u0003\u0003\ni\u0005K\u0002\u0001\t\u000b\u0004B!a\u0011\u0005H&!A\u0011ZA#\u00051!UM^3m_B,'/\u00119j\u0001")
public abstract class JdbcDialect
implements scala.Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        return t;
    }

    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.fromJavaTimestampNoRebase(t));
    }

    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        long micros = DateTimeUtils$.MODULE$.localDateTimeToMicros(ldt);
        return DateTimeUtils$.MODULE$.toJavaTimestampNoRebase(micros);
    }

    public Function1<Object, Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return (Function1 & Serializable & scala.Serializable)partitionId -> JdbcDialect.$anonfun$createConnectionFactory$1(driverClass, options, BoxesRunTime.unboxToInt((Object)partitionId));
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("\"").append(colName).append("\"").toString();
    }

    public void createTable(Statement statement, String tableName, String strSchema, JdbcOptionsInWrite options) {
        String createTableOptions = options.createTableOptions();
        statement.executeUpdate(new StringBuilder(17).append("CREATE TABLE ").append(tableName).append(" (").append(strSchema).append(") ").append(createTableOptions).toString());
    }

    public String getTableExistsQuery(String table) {
        return new StringBuilder(24).append("SELECT 1 FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        if (value == null) {
            return null;
        }
        return StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            return new StringBuilder(2).append("'").append(timestampFormatter.format(instant)).append("'").toString();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new StringBuilder(2).append("'").append(date).append("'").toString();
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return new StringBuilder(2).append("'").append(DateFormatter$.MODULE$.apply().format(localDate)).append("'").toString();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> this.compileValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString(", ");
        }
        return value2;
    }

    public boolean isSupportedFunction(String funcName) {
        return false;
    }

    public Option<String> compileExpression(Expression expr) {
        Some some;
        JDBCSQLBuilder jdbcSQLBuilder = new JDBCSQLBuilder();
        try {
            some = new Some((Object)jdbcSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return this.compileExpression((Expression)aggFunction);
    }

    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return Nil$.MODULE$;
    }

    public void createSchema(Statement statement, String schema, String comment) {
        String schemaCommentQuery = new StringOps(Predef$.MODULE$.augmentString(comment)).nonEmpty() ? this.getSchemaCommentQuery(schema, comment) : comment;
        statement.executeUpdate(new StringBuilder(14).append("CREATE SCHEMA ").append(this.quoteIdentifier(schema)).toString());
        if (new StringOps(Predef$.MODULE$.augmentString(comment)).nonEmpty()) {
            statement.executeUpdate(schemaCommentQuery);
            return;
        }
    }

    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        ResultSet rs = conn.getMetaData().getSchemas(null, schema);
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        ResultSet rs = conn.getMetaData().getSchemas();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(oldTable).append(" RENAME TO ").append(newTable).toString();
    }

    public String renameTable(Identifier oldTable, Identifier newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(this.getFullyQualifiedQuotedTableName(oldTable)).append(" RENAME TO ").append(this.getFullyQualifiedQuotedTableName(newTable)).toString();
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable & scala.Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            }
            if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            }
            if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            }
            if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            }
            if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            }
            throw QueryCompilationErrors$.MODULE$.unsupportedTableChangeInJDBCCatalogError(change);
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").append(" ").append(this.quoteIdentifier(newName)).toString();
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(this.quoteIdentifier(columnName)).toString();
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET ").append(nullable).toString();
    }

    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(23).append("COMMENT ON TABLE ").append(table).append(" IS '").append(comment).append("'").toString();
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS '").append(comment).append("'").toString();
    }

    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(26).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS NULL").toString();
    }

    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString();
        }
        return new StringBuilder(12).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).toString();
    }

    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        throw new UnsupportedOperationException("createIndex is not supported");
    }

    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("indexExists is not supported");
    }

    public String dropIndex(String indexName, Identifier tableIdent) {
        throw new UnsupportedOperationException("dropIndex is not supported");
    }

    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("listIndexes is not supported");
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$5();
        scala.collection.immutable.Map x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        QueryContext[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, (Option)x$2, x$5, x$6, x$7);
    }

    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return new StringBuilder(6).append("LIMIT ").append(limit).toString();
        }
        return "";
    }

    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return new StringBuilder(7).append("OFFSET ").append(offset).toString();
        }
        return "";
    }

    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new JdbcSQLQueryBuilder(this, options);
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsOffset() {
        return false;
    }

    public boolean supportsTableSample() {
        return false;
    }

    public String getTableSample(TableSampleInfo sample) {
        throw new UnsupportedOperationException("TableSample is not supported by this data source");
    }

    public String getFullyQualifiedQuotedTableName(Identifier ident) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).$colon$plus((Object)ident.name(), ClassTag$.MODULE$.apply(String.class)))).map((Function1 & Serializable & scala.Serializable)colName -> this.quoteIdentifier((String)colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
    }

    public static final /* synthetic */ Connection $anonfun$createConnectionFactory$1(String driverClass$1, JDBCOptions options$1, int partitionId) {
        DriverRegistry$.MODULE$.register(driverClass$1);
        Driver driver = DriverRegistry$.MODULE$.get(driverClass$1);
        Connection connection = ConnectionProvider$.MODULE$.create(driver, (scala.collection.immutable.Map<String, String>)options$1.parameters(), options$1.connectionProviderName());
        Predef$.MODULE$.require(connection != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("The driver could not open a JDBC connection. Check the URL: ").append(options$1.url()).toString());
        return connection;
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }

    public class JDBCSQLBuilder
    extends V2ExpressionSQLBuilder {
        private /* synthetic */ String super$visitLiteral(Literal x$1) {
            return super.visitLiteral(x$1);
        }

        public String inputToSQLNoBool(Expression input) {
            boolean bl = false;
            Predicate predicate = null;
            Expression expression = input;
            if (expression instanceof Predicate) {
                bl = true;
                predicate = (Predicate)expression;
                String string = predicate.name();
                String string2 = "ALWAYS_TRUE";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return "1";
                }
            }
            if (bl) {
                String string = predicate.name();
                String string3 = "ALWAYS_FALSE";
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    return "0";
                }
            }
            if (bl) {
                return this.predicateToIntSQL(this.inputToSQL((Expression)predicate));
            }
            return super.inputToSQL(input);
        }

        public String predicateToIntSQL(String input) {
            return new StringBuilder(28).append("CASE WHEN ").append(input).append(" THEN 1 ELSE 0 END").toString();
        }

        public String visitLiteral(Literal<?> literal) {
            return (String)Option$.MODULE$.apply(literal.value()).map((Function1 & Serializable & scala.Serializable)v -> this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().compileValue(CatalystTypeConverters$.MODULE$.convertToScala(v, literal.dataType())).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$visitLiteral(literal));
        }

        public String visitNamedReference(NamedReference namedRef) {
            if (namedRef.fieldNames().length > 1) {
                throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("Filter push down", namedRef.toString());
            }
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().quoteIdentifier((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namedRef.fieldNames())).head());
        }

        public String visitCast(String l, DataType dataType) {
            String databaseTypeDefinition = (String)this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().getJDBCType(dataType).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.databaseTypeDefinition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> dataType.typeName());
            return new StringBuilder(10).append("CAST(").append(l).append(" AS ").append(databaseTypeDefinition).append(")").toString();
        }

        public String visitSQLFunction(String funcName, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                return new StringBuilder(2).append(this.dialectFunctionName(funcName)).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).mkString(", ")).append(")").toString();
            }
            throw new UnsupportedOperationException(new StringBuilder(28).append(this.getClass().getSimpleName()).append(" does not support function: ").append(funcName).toString());
        }

        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                return super.visitAggregateFunction(this.dialectFunctionName(funcName), isDistinct, inputs);
            }
            throw new UnsupportedOperationException(new StringBuilder(38).append(this.getClass().getSimpleName()).append(" does not support aggregate function: ").append(funcName).toString());
        }

        public String dialectFunctionName(String funcName) {
            return funcName;
        }

        public String visitOverlay(String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("OVERLAY")) {
                return super.visitOverlay(inputs);
            }
            throw new UnsupportedOperationException(new StringBuilder(35).append(this.getClass().getSimpleName()).append(" does not support function: OVERLAY").toString());
        }

        public String visitTrim(String direction, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("TRIM")) {
                return super.visitTrim(direction, inputs);
            }
            throw new UnsupportedOperationException(new StringBuilder(32).append(this.getClass().getSimpleName()).append(" does not support function: TRIM").toString());
        }

        public /* synthetic */ JdbcDialect org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer() {
            return JdbcDialect.this;
        }

        public JDBCSQLBuilder() {
            if (JdbcDialect.this == null) {
                throw null;
            }
        }
    }
}

