/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Calendar;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.trace.CalciteLogger;
import org.slf4j.LoggerFactory;

public class VisitorDataContext
implements DataContext {
    private static final CalciteLogger LOGGER = new CalciteLogger(LoggerFactory.getLogger((String)VisitorDataContext.class.getName()));
    private final Object[] values;

    public VisitorDataContext(Object[] values) {
        this.values = values;
    }

    @Override
    public SchemaPlus getRootSchema() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public JavaTypeFactory getTypeFactory() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public QueryProvider getQueryProvider() {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public Object get(String name) {
        if (name.equals("inputRecord")) {
            return this.values;
        }
        return null;
    }

    public static DataContext of(RelNode targetRel, LogicalFilter queryRel) {
        return VisitorDataContext.of(targetRel.getRowType(), queryRel.getCondition());
    }

    public static DataContext of(RelDataType rowType, RexNode rex) {
        RexNode secondOperand;
        int size = rowType.getFieldList().size();
        Object[] values = new Object[size];
        List<RexNode> operands = ((RexCall)rex).getOperands();
        RexNode firstOperand = operands.get(0);
        Pair<Integer, ?> value = VisitorDataContext.getValue(firstOperand, secondOperand = operands.get(1));
        if (value != null) {
            int index = value.getKey();
            values[index] = value.getValue();
            return new VisitorDataContext(values);
        }
        return null;
    }

    public static DataContext of(RelDataType rowType, List<Pair<RexInputRef, RexNode>> usageList) {
        int size = rowType.getFieldList().size();
        Object[] values = new Object[size];
        for (Pair<RexInputRef, RexNode> elem : usageList) {
            Pair<Integer, ?> value = VisitorDataContext.getValue(elem.getKey(), elem.getValue());
            if (value == null) {
                LOGGER.warn("{} is not handled for {} for checking implication", (Object)elem.getKey(), (Object)elem.getValue());
                return null;
            }
            int index = value.getKey();
            values[index] = value.getValue();
        }
        return new VisitorDataContext(values);
    }

    public static Pair<Integer, ?> getValue(RexNode inputRef, RexNode literal) {
        inputRef = VisitorDataContext.removeCast(inputRef);
        literal = VisitorDataContext.removeCast(literal);
        if (inputRef instanceof RexInputRef && literal instanceof RexLiteral) {
            int index = ((RexInputRef)inputRef).getIndex();
            Object value = ((RexLiteral)literal).getValue();
            RelDataType type = inputRef.getType();
            if (type.getSqlTypeName() == null) {
                LOGGER.warn("{} returned null SqlTypeName", inputRef.toString());
                return null;
            }
            switch (type.getSqlTypeName()) {
                case INTEGER: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, ((BigDecimal)value).intValue());
                    }
                }
                case DOUBLE: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, ((BigDecimal)value).doubleValue());
                    }
                }
                case REAL: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, Float.valueOf(((BigDecimal)value).floatValue()));
                    }
                }
                case BIGINT: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, ((BigDecimal)value).longValue());
                    }
                }
                case SMALLINT: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, ((BigDecimal)value).shortValue());
                    }
                }
                case TINYINT: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, Short.valueOf(((BigDecimal)value).byteValue()));
                    }
                }
                case DECIMAL: {
                    if (value instanceof BigDecimal) {
                        return Pair.of(index, value);
                    }
                }
                case DATE: {
                    if (value instanceof NlsString) {
                        value = ((RexLiteral)literal).getValue2();
                        Date dateValue = Date.valueOf((String)value);
                        return Pair.of(index, dateValue);
                    }
                    if (value instanceof Calendar) {
                        long timeInMillis = ((Calendar)value).getTimeInMillis();
                        return Pair.of(index, new Date(timeInMillis));
                    }
                }
                case CHAR: {
                    if (value instanceof NlsString) {
                        NlsString nl = (NlsString)value;
                        return Pair.of(index, Character.valueOf(nl.getValue().charAt(0)));
                    }
                }
                case VARCHAR: {
                    if (!(value instanceof NlsString)) break;
                    return Pair.of(index, ((NlsString)value).getValue());
                }
            }
            LOGGER.warn("{} for value of class {} is being handled in default way", (Object)type.getSqlTypeName(), (Object)value.getClass());
            if (value instanceof NlsString) {
                return Pair.of(index, ((NlsString)value).getValue());
            }
            return Pair.of(index, value);
        }
        return null;
    }

    private static RexNode removeCast(RexNode inputRef) {
        RexCall castedRef;
        SqlOperator operator;
        if (inputRef instanceof RexCall && (operator = (castedRef = (RexCall)inputRef).getOperator()) instanceof SqlCastFunction) {
            inputRef = castedRef.getOperands().get(0);
        }
        return inputRef;
    }
}

