/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.aspect;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.streampark.common.util.DateUtils;
import org.apache.streampark.common.util.ReflectUtils;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.annotation.OpenAPI;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.SpringProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class OpenAPIAspect {
    private static final Logger log = LoggerFactory.getLogger(OpenAPIAspect.class);
    private final Set<String> openapiWhitelist = new HashSet<String>();

    @PostConstruct
    public void initOpenapiWhitelist() {
        String whiteLists = SpringProperties.getProperty((String)"streampark.openapi.white-list");
        if (StringUtils.isNotBlank((CharSequence)whiteLists)) {
            String[] whiteList;
            for (String order : whiteList = whiteLists.trim().split("\\s|,")) {
                if (!StringUtils.isNotBlank((CharSequence)order)) continue;
                if (!order.startsWith("/")) {
                    order = "/" + order;
                }
                this.openapiWhitelist.add(order);
            }
        }
    }

    @Pointcut(value="execution(public org.apache.streampark.console.base.domain.RestResponse org.apache.streampark.console.core.controller.*.*(..))")
    public void openAPIPointcut() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Around(value="openAPIPointcut()")
    public RestResponse openAPIPointcut(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        log.debug("request aspect, method:{}", (Object)methodSignature.getName());
        Boolean isApi = (Boolean)SecurityUtils.getSubject().getSession().getAttribute((Object)"is_api_token");
        if (isApi == null || !isApi.booleanValue()) return (RestResponse)joinPoint.proceed();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        OpenAPI openAPI = methodSignature.getMethod().getAnnotation(OpenAPI.class);
        if (openAPI == null) {
            String url = request.getRequestURI();
            if (!this.openapiWhitelist.contains(url)) throw new UnsupportedOperationException("Openapi unsupported: " + url);
            log.info("request by openapi white-list: {} ", (Object)url);
            return (RestResponse)joinPoint.proceed();
        } else {
            Object[] objects = joinPoint.getArgs();
            for (OpenAPI.Param param : openAPI.param()) {
                String bingFor = param.bindFor();
                if (!StringUtils.isNotBlank((CharSequence)bingFor)) continue;
                String name = param.name();
                for (Object args : objects) {
                    Field bindForField = ReflectUtils.getField(args.getClass(), (String)bingFor);
                    if (bindForField == null) continue;
                    String value = request.getParameter(name);
                    bindForField.setAccessible(true);
                    if (value == null) continue;
                    if (param.type().equals(String.class)) {
                        bindForField.set(args, value.toString());
                        continue;
                    }
                    if (param.type().equals(Boolean.class) || param.type().equals(Boolean.TYPE)) {
                        bindForField.set(args, Boolean.parseBoolean(value.toString()));
                        continue;
                    }
                    if (param.type().equals(Integer.class) || param.type().equals(Integer.TYPE)) {
                        bindForField.set(args, Integer.parseInt(value.toString()));
                        continue;
                    }
                    if (param.type().equals(Long.class) || param.type().equals(Long.TYPE)) {
                        bindForField.set(args, Long.parseLong(value.toString()));
                        continue;
                    }
                    if (!param.type().equals(Date.class)) continue;
                    bindForField.set(args, DateUtils.parse((String)value.toString(), (String)DateUtils.fullFormat(), (TimeZone)TimeZone.getDefault()));
                }
            }
        }
        return (RestResponse)joinPoint.proceed();
    }
}

