/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;

public class RegisteredPriorityQueueStateBackendMetaInfo<T>
extends RegisteredStateMetaInfoBase {
    @Nonnull
    private final StateSerializerProvider<T> elementSerializerProvider;

    public RegisteredPriorityQueueStateBackendMetaInfo(@Nonnull String name, @Nonnull TypeSerializer<T> elementSerializer) {
        this(name, StateSerializerProvider.fromNewRegisteredSerializer(elementSerializer));
    }

    public RegisteredPriorityQueueStateBackendMetaInfo(StateMetaInfoSnapshot snapshot) {
        this(snapshot.getName(), StateSerializerProvider.fromPreviousSerializerSnapshot((TypeSerializerSnapshot)Preconditions.checkNotNull(snapshot.getTypeSerializerSnapshot(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER))));
        Preconditions.checkState((StateMetaInfoSnapshot.BackendStateType.PRIORITY_QUEUE == snapshot.getBackendStateType() ? 1 : 0) != 0);
    }

    private RegisteredPriorityQueueStateBackendMetaInfo(@Nonnull String name, @Nonnull StateSerializerProvider<T> elementSerializerProvider) {
        super(name);
        this.elementSerializerProvider = elementSerializerProvider;
    }

    @Override
    @Nonnull
    public StateMetaInfoSnapshot snapshot() {
        return this.computeSnapshot();
    }

    @Nonnull
    public TypeSerializer<T> getElementSerializer() {
        return this.elementSerializerProvider.currentSchemaSerializer();
    }

    @Nonnull
    public TypeSerializerSchemaCompatibility<T> updateElementSerializer(TypeSerializer<T> newElementSerializer) {
        return this.elementSerializerProvider.registerNewSerializerForRestoredState(newElementSerializer);
    }

    @Nullable
    public TypeSerializer<T> getPreviousElementSerializer() {
        return this.elementSerializerProvider.previousSchemaSerializer();
    }

    private StateMetaInfoSnapshot computeSnapshot() {
        TypeSerializer<T> elementSerializer = this.getElementSerializer();
        Map<String, TypeSerializer<?>> serializerMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString(), elementSerializer.duplicate());
        Map<String, TypeSerializerSnapshot<?>> serializerSnapshotMap = Collections.singletonMap(StateMetaInfoSnapshot.CommonSerializerKeys.VALUE_SERIALIZER.toString(), elementSerializer.snapshotConfiguration());
        return new StateMetaInfoSnapshot(this.name, StateMetaInfoSnapshot.BackendStateType.PRIORITY_QUEUE, Collections.emptyMap(), serializerSnapshotMap, serializerMap);
    }

    public RegisteredPriorityQueueStateBackendMetaInfo deepCopy() {
        return new RegisteredPriorityQueueStateBackendMetaInfo<T>(this.name, this.getElementSerializer().duplicate());
    }
}

