/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.schema;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.DocType;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class ElementValidator
implements Serializable {
    private final String tagName;
    private final ImmutableSet<Flag> flags;
    private final String innerContentType;
    private final ImmutableMap<String, DocType> docTypeMap;
    private final ImmutableMap<String, AttributeValidator> attrMap;

    public String getTagName() {
        return this.tagName;
    }

    public boolean isFlagSet(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public String getInnerContentType() {
        return this.innerContentType;
    }

    public DocType getDocType(String name) {
        return this.docTypeMap.get(name);
    }

    public Map<String, AttributeValidator> getAttributeValidatorMap() {
        return Collections.unmodifiableMap(this.attrMap);
    }

    public AttributeValidator getAttributeValidator(String attrName) {
        return this.attrMap.get(attrName);
    }

    public ElementValidator(String tagName, Set<Flag> flags, String innerContentType, Iterable<DocType> docTypes, Iterable<AttributeValidator> attrs) {
        this.tagName = Preconditions.checkNotNull(tagName);
        this.flags = ImmutableSet.copyOf(flags);
        this.innerContentType = innerContentType;
        ImmutableMap.Builder<String, DocType> docTypeMapBuilder = ImmutableMap.builder();
        for (DocType docType : docTypes) {
            docTypeMapBuilder.put(docType.getName(), docType);
        }
        this.docTypeMap = docTypeMapBuilder.build();
        ImmutableMap.Builder<String, AttributeValidator> attrMapBuilder = ImmutableMap.builder();
        for (AttributeValidator attr : attrs) {
            attrMapBuilder.put(attr.getName(), attr);
        }
        this.attrMap = attrMapBuilder.build();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ElementValidator && this.equals((ElementValidator)that);
    }

    private boolean equals(ElementValidator that) {
        return Objects.equal(this.attrMap, that.attrMap) && Objects.equal(this.docTypeMap, that.docTypeMap) && Objects.equal(this.flags, that.flags) && Objects.equal(this.innerContentType, that.innerContentType) && Objects.equal(this.tagName, that.tagName);
    }

    public int hashCode() {
        return Objects.hashCode(this.attrMap, this.docTypeMap, this.flags, this.innerContentType, this.tagName);
    }

    public static enum Flag {
        CHILDLESS,
        EVILCDATA,
        NOENDTAG,
        OPTIONALENDTAG,
        DEPRECATED,
        LOOSEDTD,
        FRAMESETDTD,
        INVISIBLEBODY,
        PRESERVESPACES,
        NONSTANDARD;

    }
}

