/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice.util;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.aopalliance.intercept.MethodInterceptor;
import org.directwebremoting.guice.util.DeclaredBy;
import org.directwebremoting.guice.util.InjectingMethodInterceptor;
import org.directwebremoting.guice.util.MethodInterceptorWrapper;
import org.directwebremoting.guice.util.Numbers;
import org.directwebremoting.guice.util.OutermostCallInterceptor;

public abstract class AbstractModule
extends com.google.inject.AbstractModule {
    private final ConcurrentMap<Object, Boolean> registeredForInjection = new ConcurrentHashMap<Object, Boolean>();
    private final AtomicBoolean ensuredSelfInjection = new AtomicBoolean(false);
    private static MethodInterceptorWrapper NULL_WRAPPER = new MethodInterceptorWrapper(){

        @Override
        public MethodInterceptor wrap(MethodInterceptor methodInterceptor) {
            return methodInterceptor;
        }
    };
    private static final AtomicLong unique = new AtomicLong();

    protected AbstractModule() {
    }

    protected void registerForInjection() {
        this.registerForInjection(null);
    }

    protected <T> void registerForInjection(T ... objects) {
        this.ensureSelfInjection(this.binder());
        if (objects != null) {
            for (T object : objects) {
                if (object == null) continue;
                this.registeredForInjection.putIfAbsent(object, true);
            }
        }
    }

    public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... methodInterceptors) {
        this.registerForInjection(methodInterceptors);
        super.bindInterceptor(classMatcher, methodMatcher, methodInterceptors);
    }

    public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, Class<?> ... methodInterceptorClasses) {
        this.bindInterceptor(classMatcher, methodMatcher, NULL_WRAPPER, methodInterceptorClasses);
    }

    public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, Key<?> ... methodInterceptorKeys) {
        this.bindInterceptor(classMatcher, methodMatcher, NULL_WRAPPER, methodInterceptorKeys);
    }

    public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptorWrapper methodInterceptorWrapper, Class<?> ... methodInterceptorClasses) {
        if (methodInterceptorClasses != null) {
            MethodInterceptor[] interceptors = new MethodInterceptor[methodInterceptorClasses.length];
            int i = 0;
            for (Class<?> cls : methodInterceptorClasses) {
                if (!MethodInterceptor.class.isAssignableFrom(cls)) {
                    this.addError("bindInterceptor: %s does not implement MethodInterceptor", new Object[]{cls.getName()});
                    continue;
                }
                Class<?> c = cls;
                interceptors[i++] = AbstractModule.wrap(methodInterceptorWrapper, c);
            }
            this.bindInterceptor(classMatcher, methodMatcher, interceptors);
        }
    }

    public void bindInterceptor(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptorWrapper methodInterceptorWrapper, Key<?> ... methodInterceptorKeys) {
        if (methodInterceptorKeys != null) {
            MethodInterceptor[] interceptors = new MethodInterceptor[methodInterceptorKeys.length];
            int i = 0;
            for (Key<?> key : methodInterceptorKeys) {
                Type type = key.getTypeLiteral().getType();
                if (!(type instanceof Class)) {
                    this.addError("bindInterceptor: %s is not a Key for a MethodInterceptor subtype", new Object[]{key});
                    continue;
                }
                Class cls = (Class)type;
                if (!MethodInterceptor.class.isAssignableFrom(cls)) {
                    this.addError("bindInterceptor: %s does not implement MethodInterceptor", new Object[]{cls.getName()});
                    continue;
                }
                Key<?> k = key;
                interceptors[i++] = AbstractModule.wrap(methodInterceptorWrapper, k);
            }
            this.bindInterceptor(classMatcher, methodMatcher, interceptors);
        }
    }

    public final void bindInterceptor(Class<?> targetType, Class<?> ... methodInterceptorClasses) {
        this.bindInterceptor(Matchers.subclassesOf(targetType), DeclaredBy.declaredBy(targetType), OutermostCallInterceptor.outermostCallWrapper(), methodInterceptorClasses);
    }

    public final void bindInterceptor(Class<?> targetType, Key<?> ... methodInterceptorKeys) {
        this.bindInterceptor(Matchers.subclassesOf(targetType), DeclaredBy.declaredBy(targetType), OutermostCallInterceptor.outermostCallWrapper(), methodInterceptorKeys);
    }

    protected void install(Module module) {
        if (module instanceof AbstractModule) {
            final AbstractModule abstractModule = (AbstractModule)module;
            Module wrapper = new Module(){

                public void configure(Binder binder) {
                    binder.install((Module)abstractModule);
                    abstractModule.ensureSelfInjection(binder);
                }
            };
            super.install(wrapper);
        } else {
            super.install(module);
        }
    }

    @Inject
    private void injectRegisteredObjects(Injector injector) {
        for (Object injectee : this.registeredForInjection.keySet()) {
            injector.injectMembers(injectee);
        }
    }

    private void ensureSelfInjection(Binder binder) {
        if (this.ensuredSelfInjection.compareAndSet(false, true)) {
            binder.bind(AbstractModule.class).annotatedWith((Annotation)Numbers.numbered(unique.incrementAndGet())).toInstance((Object)this);
        }
    }

    private static MethodInterceptor wrap(MethodInterceptorWrapper wrapper, Class<? extends MethodInterceptor> cls) {
        return wrapper.wrap(new InjectingMethodInterceptor(cls));
    }

    private static MethodInterceptor wrap(MethodInterceptorWrapper wrapper, Key<? extends MethodInterceptor> key) {
        return wrapper.wrap(new InjectingMethodInterceptor(key));
    }
}

