/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredParts
extends AbstractSecurityAssertion {
    private ArrayList<Header> headers = new ArrayList();

    public RequiredParts(int version) {
        this.setVersion(version);
    }

    public ArrayList<Header> getHeaders() {
        return this.headers;
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public QName getName() {
        return SP12Constants.REQUIRED_PARTS;
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        RequiredParts.writeStartElement(writer, prefix, localName, namespaceURI);
        for (Header header : this.headers) {
            RequiredParts.writeStartElement(writer, prefix, "Header", namespaceURI);
            if (header.getName() != null) {
                writer.writeAttribute("Name", header.getName());
            }
            writer.writeAttribute("Namespace", header.getNamespace());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

