/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.syncope.client.ui.commons;

public final class SAML2SP4UIConstants {

    public static final String URL_CONTEXT = "saml2sp4ui";

    public static final String PARAM_IDP = "idp";

    public static final String PARAM_REAUTH = "reauth";

    public static final String SAML2SP4UI_JWT = "saml2sp4ui.jwt";

    public static final String SAML2SP4UI_JWT_EXPIRATION = "saml2sp4ui.jwt.expiration";

    public static final String SAML2SP4UI_SLO_SUPPORTED = "saml2sp4ui.sloSupported";

    public static final String SAML2SP4UI_IDP_ENTITY_ID = "saml2sp4ui.idpEntityID";

    private SAML2SP4UIConstants() {
        // private constructor for static utility class
    }
}
