/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.client.TezApiVersionInfo;
import org.apache.tez.client.TezAppMasterStatus;
import org.apache.tez.common.AsyncDispatcher;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.dag.api.DAGSubmissionTimedOut;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGClientHandler;
import org.apache.tez.dag.api.client.DAGClientImpl;
import org.apache.tez.dag.api.client.DAGClientImplLocal;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.DAGAppMaster;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.LocalDAGAppMaster;
import org.apache.tez.dag.app.dag.DAG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalClient
extends FrameworkClient {
    public static final Logger LOG = LoggerFactory.getLogger(LocalClient.class);
    private volatile DAGAppMaster dagAppMaster = null;
    private volatile DAGClientHandler clientHandler = null;
    private Thread dagAmThread;
    private Configuration conf;
    private final long clusterTimeStamp = System.currentTimeMillis();
    private final long TIME_OUT = 60000L;
    private int appIdNumber = 1;
    private boolean isSession;
    private TezApiVersionInfo versionInfo = new TezApiVersionInfo();
    private volatile Throwable amFailException = null;
    private boolean isLocalWithoutNetwork;
    private String amHost;
    private int amPort;
    private static final String localModeDAGSchedulerClassName = "org.apache.tez.dag.app.dag.impl.DAGSchedulerNaturalOrderControlled";

    public void init(TezConfiguration tezConf) {
        this.conf = tezConf;
        this.conf.setBoolean("tez.ignore.lib.uris", true);
        this.conf.set("tez.am.dag.scheduler.class", localModeDAGSchedulerClassName);
        this.isSession = tezConf.getBoolean("tez.am.mode.session", false);
        this.conf.setBoolean("tez.am.tez-ui.webservice.enable", false);
        this.isLocalWithoutNetwork = tezConf.getBoolean("tez.local.mode.without.network", false);
    }

    public void start() {
    }

    public void stop() {
    }

    public void close() throws IOException {
        if (this.dagAppMaster != null) {
            this.dagAppMaster.stop();
        }
    }

    public YarnClientApplication createApplication() throws YarnException, IOException {
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        ApplicationId appId = ApplicationId.newInstance((long)this.clusterTimeStamp, (int)this.appIdNumber++);
        context.setApplicationId(appId);
        GetNewApplicationResponse response = (GetNewApplicationResponse)Records.newRecord(GetNewApplicationResponse.class);
        response.setApplicationId(appId);
        return new YarnClientApplication(response, context);
    }

    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws IOException, YarnException {
        ApplicationId appId = appContext.getApplicationId();
        this.startDAGAppMaster(appContext);
        return appId;
    }

    public void killApplication(ApplicationId appId) {
        try {
            if (this.clientHandler != null) {
                this.clientHandler.shutdownAM();
            }
        }
        catch (TezException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunning() {
        return true;
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) {
        ApplicationReport report = (ApplicationReport)Records.newRecord(ApplicationReport.class);
        report.setApplicationId(appId);
        report.setCurrentApplicationAttemptId(this.dagAppMaster.getAttemptID());
        AppContext runningAppContext = this.dagAppMaster.getContext();
        if (runningAppContext != null) {
            DAG dag = runningAppContext.getCurrentDAG();
            if (dag != null) {
                report.setUser(runningAppContext.getUser());
            }
            report.setName(runningAppContext.getApplicationName());
            report.setStartTime(runningAppContext.getStartTime());
        }
        report.setHost(this.dagAppMaster.getAppNMHost());
        report.setRpcPort(this.dagAppMaster.getRpcPort());
        report.setClientToAMToken(null);
        report.setYarnApplicationState(this.convertDAGAppMasterState(this.dagAppMaster.getState()));
        report.setFinalApplicationStatus(this.convertDAGAppMasterStateToFinalYARNState(this.dagAppMaster.getState()));
        List<String> diagnostics = this.dagAppMaster.getDiagnostics();
        if (diagnostics != null) {
            report.setDiagnostics(diagnostics.toString());
        }
        report.setTrackingUrl("N/A");
        report.setFinishTime(0L);
        report.setApplicationResourceUsageReport(null);
        report.setOriginalTrackingUrl("N/A");
        report.setProgress(this.dagAppMaster.getProgress());
        report.setAMRMToken(null);
        this.amHost = this.dagAppMaster.getAppNMHost();
        this.amPort = this.dagAppMaster.getRpcPort();
        return report;
    }

    protected FinalApplicationStatus convertDAGAppMasterStateToFinalYARNState(DAGAppMasterState dagAppMasterState) {
        switch (dagAppMasterState) {
            case NEW: 
            case INITED: 
            case RECOVERING: 
            case IDLE: 
            case RUNNING: {
                return FinalApplicationStatus.UNDEFINED;
            }
            case SUCCEEDED: {
                return FinalApplicationStatus.SUCCEEDED;
            }
            case FAILED: {
                return FinalApplicationStatus.FAILED;
            }
            case KILLED: {
                return FinalApplicationStatus.KILLED;
            }
            case ERROR: {
                return FinalApplicationStatus.FAILED;
            }
        }
        return FinalApplicationStatus.UNDEFINED;
    }

    protected YarnApplicationState convertDAGAppMasterState(DAGAppMasterState dagAppMasterState) {
        switch (dagAppMasterState) {
            case NEW: {
                return YarnApplicationState.NEW;
            }
            case INITED: 
            case RECOVERING: 
            case IDLE: 
            case RUNNING: {
                return YarnApplicationState.RUNNING;
            }
            case SUCCEEDED: {
                return YarnApplicationState.FINISHED;
            }
            case FAILED: {
                return YarnApplicationState.FAILED;
            }
            case KILLED: {
                return YarnApplicationState.KILLED;
            }
            case ERROR: {
                return YarnApplicationState.FAILED;
            }
        }
        return YarnApplicationState.SUBMITTED;
    }

    protected void startDAGAppMaster(ApplicationSubmissionContext appContext) throws IOException {
        if (this.dagAmThread == null) {
            try {
                this.dagAmThread = this.createDAGAppMaster(appContext);
                this.dagAmThread.start();
                long waitingTime = 0L;
                while (this.amFailException == null) {
                    if (this.dagAppMaster != null) {
                        DAGAppMasterState dagAMState = this.dagAppMaster.getState();
                        LOG.info("DAGAppMaster state: " + (Object)((Object)dagAMState));
                        if (dagAMState.equals((Object)DAGAppMasterState.NEW)) {
                            LOG.info("DAGAppMaster is not started wait for 100ms...");
                        } else if (dagAMState.equals((Object)DAGAppMasterState.INITED)) {
                            LOG.info("DAGAppMaster is not started wait for 100ms...");
                        } else {
                            if (dagAMState.equals((Object)DAGAppMasterState.ERROR)) {
                                throw new TezException("DAGAppMaster got an error during initialization");
                            }
                            if (!dagAMState.equals((Object)DAGAppMasterState.KILLED)) break;
                            throw new TezException("DAGAppMaster is killed");
                        }
                    }
                    if (waitingTime < 60000L) {
                        LOG.info("DAGAppMaster is not created wait for 100ms...");
                        Thread.sleep(100L);
                        waitingTime += 100L;
                        continue;
                    }
                    throw new TezException("Time out creating DAGAppMaster");
                }
            }
            catch (Throwable t) {
                LOG.error("Error starting DAGAppMaster", t);
                if (this.dagAmThread != null) {
                    this.dagAmThread.interrupt();
                }
                throw new IOException(t);
            }
            if (this.amFailException != null) {
                throw new IOException(this.amFailException);
            }
        }
    }

    protected Thread createDAGAppMaster(final ApplicationSubmissionContext appContext) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ApplicationId appId = appContext.getApplicationId();
                    Path staging = TezCommonUtils.getTezSystemStagingPath((Configuration)LocalClient.this.conf, (String)appId.toString());
                    FileSystem stagingFs = staging.getFileSystem(LocalClient.this.conf);
                    LocalFileSystem localFs = FileSystem.getLocal((Configuration)LocalClient.this.conf);
                    Path userDir = localFs.makeQualified(new Path(staging.toUri().getPath() + "_wd"));
                    LOG.info("Using working directory: " + userDir.toUri().getPath());
                    FileUtil.copy((FileSystem)stagingFs, (Path)staging, (FileSystem)localFs, (Path)userDir, (boolean)false, (Configuration)LocalClient.this.conf);
                    Path logDir = new Path(userDir, "localmode-log-dir");
                    Path localDir = new Path(userDir, "localmode-local-dir");
                    if (!localFs.mkdirs(logDir)) {
                        throw new IOException("Unable to create log directory, try to create it manually for further insights: " + logDir);
                    }
                    if (!localFs.mkdirs(localDir)) {
                        throw new IOException("Unable to create local directory, try to create it manually for further insights: " + localDir);
                    }
                    UserGroupInformation.setConfiguration((Configuration)LocalClient.this.conf);
                    ByteBuffer tokens = appContext.getAMContainerSpec().getTokens();
                    Credentials amCredentials = tokens != null ? TezCommonUtils.parseCredentialsBytes((byte[])tokens.array()) : new Credentials();
                    ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
                    ContainerId cId = ContainerId.newInstance((ApplicationAttemptId)applicationAttemptId, (int)1);
                    String currentHost = InetAddress.getLocalHost().getHostName();
                    int nmPort = 0;
                    int nmHttpPort = 8042;
                    long appSubmitTime = System.currentTimeMillis();
                    LocalClient.this.dagAppMaster = LocalClient.this.createDAGAppMaster(applicationAttemptId, cId, currentHost, nmPort, nmHttpPort, (Clock)SystemClock.getInstance(), appSubmitTime, LocalClient.this.isSession, userDir.toUri().getPath(), new String[]{localDir.toUri().getPath()}, new String[]{logDir.toUri().getPath()}, amCredentials, UserGroupInformation.getCurrentUser().getShortUserName());
                    DAGAppMaster.initAndStartAppMaster(LocalClient.this.dagAppMaster, LocalClient.this.conf);
                    LocalClient.this.clientHandler = new DAGClientHandler(LocalClient.this.dagAppMaster);
                    ((AsyncDispatcher)LocalClient.this.dagAppMaster.getDispatcher()).setDrainEventsOnStop();
                }
                catch (Throwable t) {
                    LOG.error("Error starting DAGAppMaster", t);
                    if (LocalClient.this.dagAppMaster != null) {
                        LocalClient.this.dagAppMaster.stop();
                        LocalClient.this.dagAppMaster = null;
                    }
                    LocalClient.this.amFailException = t;
                }
            }
        });
        thread.setName("DAGAppMaster Thread");
        LOG.info("DAGAppMaster thread has been created");
        return thread;
    }

    @VisibleForTesting
    protected DAGAppMaster createDAGAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId cId, String currentHost, int nmPort, int nmHttpPort, Clock clock, long appSubmitTime, boolean isSession, String userDir, String[] localDirs, String[] logDirs, Credentials credentials, String jobUserName) throws IOException {
        DAGProtos.AMPluginDescriptorProto amPluginDescriptorProto = TezUtilsInternal.readUserSpecifiedTezConfiguration((String)userDir).getAmPluginDescriptor();
        return this.isLocalWithoutNetwork ? new LocalDAGAppMaster(applicationAttemptId, cId, currentHost, nmPort, nmHttpPort, (Clock)SystemClock.getInstance(), appSubmitTime, isSession, userDir, localDirs, logDirs, this.versionInfo.getVersion(), credentials, jobUserName, amPluginDescriptorProto) : new DAGAppMaster(applicationAttemptId, cId, currentHost, nmPort, nmHttpPort, (Clock)SystemClock.getInstance(), appSubmitTime, isSession, userDir, localDirs, logDirs, this.versionInfo.getVersion(), credentials, jobUserName, amPluginDescriptorProto);
    }

    public TezAppMasterStatus getAMStatus(Configuration configuration, ApplicationId appId, UserGroupInformation ugi) throws TezException, ServiceException, IOException {
        if (this.isLocalWithoutNetwork) {
            if (this.clientHandler == null) {
                return TezAppMasterStatus.INITIALIZING;
            }
            return this.clientHandler.getTezAppMasterStatus();
        }
        return super.getAMStatus(configuration, appId, ugi);
    }

    public DAGClient submitDag(org.apache.tez.dag.api.DAG dag, DAGClientAMProtocolRPC.SubmitDAGRequestProto request, String clientName, ApplicationId sessionAppId, long clientTimeout, UserGroupInformation ugi, TezConfiguration tezConf) throws IOException, TezException, DAGSubmissionTimedOut {
        Map additionalResources = null;
        if (request.hasAdditionalAmResources()) {
            additionalResources = DagTypeConverters.convertFromPlanLocalResources((DAGProtos.PlanLocalResourcesProto)request.getAdditionalAmResources());
        }
        String dagId = this.dagAppMaster.submitDAGToAppMaster(request.getDAGPlan(), additionalResources);
        return this.getDAGClient(sessionAppId, dagId, tezConf, ugi);
    }

    public DAGClient getDAGClient(ApplicationId appId, final String dagId, TezConfiguration tezConf, UserGroupInformation ugi) {
        return this.isLocalWithoutNetwork ? new DAGClientImplLocal(appId, dagId, tezConf, (FrameworkClient)this, ugi, (BiFunction)new BiFunction<Set<StatusGetOpts>, Long, DAGStatus>(){

            @Override
            public DAGStatus apply(Set<StatusGetOpts> statusOpts, Long timeout) {
                try {
                    return LocalClient.this.clientHandler.getDAGStatus(dagId, statusOpts, timeout);
                }
                catch (TezException e) {
                    throw new RuntimeException(e);
                }
            }
        }, (BiFunction)new BiFunction<Set<StatusGetOpts>, String, VertexStatus>(){

            @Override
            public VertexStatus apply(Set<StatusGetOpts> statusOpts, String vertexName) {
                try {
                    return LocalClient.this.clientHandler.getVertexStatus(dagId, vertexName, statusOpts);
                }
                catch (TezException e) {
                    throw new RuntimeException(e);
                }
            }
        }) : new DAGClientImpl(appId, dagId, tezConf, (FrameworkClient)this, ugi);
    }

    public boolean shutdownSession(Configuration configuration, ApplicationId sessionAppId, UserGroupInformation ugi) throws TezException, IOException, ServiceException {
        if (this.isLocalWithoutNetwork) {
            if (this.clientHandler != null) {
                this.clientHandler.shutdownAM();
            }
            return true;
        }
        return super.shutdownSession(configuration, sessionAppId, ugi);
    }

    public String getAmHost() {
        return this.amHost;
    }

    public int getAmPort() {
        return this.amPort;
    }
}

